# -*- coding: utf-8; indent-tabs-mode: nil; -*-

import os
import re

from setuptools import setup


pkg_root = os.path.dirname(__file__)

_version_re = re.compile(br"^\s*__version__\s*=\s*(\"|')(.*)\1\s*(#.*)?$",
                         re.MULTILINE)

with open(os.path.join(pkg_root, "data_schema", "__init__.py"), "rb") as vf:
    version = _version_re.search(vf.read()).group(2).decode("utf-8")


setup(version=version)
