# -*- coding: utf-8 -*-
r"""Read configuration settings from Python files

"""

from __future__ import division, absolute_import, print_function

import locale
try:
    from collections import OrderedDict as DictImpl
except ImportError:
    try:
        from ordereddict import OrderedDict as DictImpl
    except ImportError:
        DictImpl = dict

from .compat import PY2


__all__ = ["load"]


def load(filename, extract=None):
    if extract is not None:
        if not isinstance(extract, (type([]), type(tuple()), type(set()), )):
            raise TypeError("`extract' must be a sequence")
    gcontext = DictImpl()
    lcontext = DictImpl()
    if PY2:
        filename2 = filename.encode(locale.getpreferredencoding())
    if PY2:
        execfile(filename2, gcontext, lcontext)
    else:
        # "rb" mode allows Python to derive the encoding automatically
        with open(filename, "rb") as vf:
            code = compile(vf.read(), filename, "exec")
            exec(code, gcontext, lcontext)
    if extract is None:
        if "__all__" in lcontext:
            extract = lcontext["__all__"]
        else:
            extract = [k for k in lcontext if not k.startswith('_')]
    #
    # Don't bail on non-existing keys and (implicitly) convert to an
    # ordered list
    #
    extract = [v for v in extract if v in lcontext]
    return DictImpl(zip(extract, [lcontext[v] for v in extract]))
