#!/usr/bin/env python
# -*- coding: utf-8 -*-

import re
import os
import sys
try:
    from setuptools import setup
except ImportError:
    from distutils.core import setup


if (sys.version_info[0] < 2) or \
        ((sys.version_info[0] == 2) and (sys.version_info[1] < 6)):
    raise ValueError("Need at least Python 2.6")


pkg_root = os.path.dirname(__file__)

_version_re = re.compile(br"^\s*__version__\s*=\s*(\"|')(.*)\1\s*(#.*)?$",
                         re.MULTILINE)

with open(os.path.join(pkg_root, "configmix", "__init__.py"), "rb") as vf:
    version = _version_re.search(vf.read()).group(2).decode("utf-8")

with open(os.path.join(pkg_root, "README"), "rt") as rf:
    long_description = rf.read()

setup(
    name="ConfigMix",
    version=version,
    author="Franz Glasner",
    license="BSD",
    url="https://pypi.dom66.de/simple/configmix/",
    description="Library for extended configuration files",
    long_description=long_description,
    packages=["configmix"],
    include_package_data=False,
    zip_safe=True,
    platforms="any",
    classifiers=[
        "Development Status :: 5 - Production/Stable",
        "Environment :: Console",
        "Intended Audience :: Developers",
        "License :: OSI Approved :: BSD License",
        "Operating System :: OS Independent",
        "Programming Language :: Python",
        "Programming Language :: Python :: 2",
        "Programming Language :: Python :: 2.6",
        "Programming Language :: Python :: 2.7",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.0",
        "Programming Language :: Python :: 3.1",
        "Programming Language :: Python :: 3.2",
        "Programming Language :: Python :: 3.3",
        "Programming Language :: Python :: 3.4",
        "Programming Language :: Python :: 3.5",
        "Topic :: Software Development :: Libraries :: Python Modules"
    ],
    install_requires = ["PyYAML>=3.0"],
)
