# -*- coding: utf-8 -*-
# :-
# :Copyright: (c) 2015-2021, Franz Glasner. All rights reserved.
# :License:   BSD-3-Clause. See LICENSE.txt for details.
# :-
"""Some important public contants

"""

from .compat import u


COMMENTS = [
    u("__comment"),
    u("__doc"),
]
"""Prefixes for comment configuration keys that are to be handled as
comments

"""

DIR_PREFIX = u("<dir>")
"""Prefix for configuration values to read other configuration files from
given directory

"""

DEL_VALUE = u("{{::DEL::}}")
"""Value for configuration items to signal that the corresponding
key-value is to be deleted when configurations are merged

"""

REF_NAMESPACE = u("ref")
"""Special internal namespace used for implementation of tree
`references`

"""
