# -*- coding: utf-8 -*-
r"""Simple wrapper for yaml to support all-unicode strings when loading
configuration files.

"""

from __future__ import division, print_function, absolute_import

import yaml


__all__ = ["safe_load", "safe_load_all", "load", "load_all"]


class ConfigLoader(yaml.Loader):

    """A YAML loader, which makes all !!str strings to Unicode.  Standard
    PyYAML does this only in the non-ASCII case.

    """

    def construct_yaml_str(self, node):
        return self.construct_scalar(node)


ConfigLoader.add_constructor(
    "tag:yaml.org,2002:str",
    ConfigLoader.construct_yaml_str)


class ConfigSafeLoader(yaml.SafeLoader):

    """A safe YAML loader, which makes all !!str strings to Unicode.
    Standard PyYAML does this only in the non-ASCII case.

    """

    def construct_yaml_str(self, node):
        return self.construct_scalar(node)


ConfigSafeLoader.add_constructor(
    "tag:yaml.org,2002:str",
    ConfigSafeLoader.construct_yaml_str)


def load(stream, Loader=ConfigLoader):
    return yaml.load(stream, Loader)


def load_all(stream, Loader=ConfigLoader):
    return yaml.load_all(stream, Loader)


def safe_load(stream):
    return yaml.load(stream, Loader=ConfigSafeLoader)


def safe_load_all(stream):
    return yaml.load_all(stream, Loader=ConfigSafeLoader)
