# -*- coding: utf-8 -*-
# :-
# :Copyright: (c) 2015-2020, Franz Glasner. All rights reserved.
# :License:   3-clause BSD. See LICENSE.txt for details.
# :-
"""Read TOML style configuration files.

"""

from __future__ import division, absolute_import, print_function


__all__ = ["load"]


import io
try:
    from collections import OrderedDict as DictImpl
except ImportError:
    try:
        from ordereddict import OrderedDict as DictImpl
    except ImportError:
        DictImpl = dict

import toml

from .compat import u2fs


def load(filename, encoding="utf-8"):
    """Load a single TOML file with name `filename` and encoding `encoding`.

    .. note:: The TOML standard requires that all TOML files are UTF-8
              encoded.

    """
    with io.open(u2fs(filename), mode="rt", encoding=encoding) as tfp:
        return toml.loads(tfp.read(), _dict=DictImpl)
