/* -*- coding: utf-8 -*- */
/*
 * Some Python helper for C.
 *
 * Also contains some interesting backports from later Python versions.
 *
 * :Copyright: (c) 2021, Franz Glasner. All rights reserved.
 * :License:   BSD-3-Clause. See LICENSE.txt for details.
 */

#if !defined(_PY_HELPER_H_d9df407295df4884a88e56699f6c6d8d)
#define _PY_HELPER_H_d9df407295df4884a88e56699f6c6d8d

#if PY_VERSION_HEX < 0x030A0000

static inline
PyObject *
Py_NewRef(PyObject *obj)
{
    Py_INCREF(obj);
    return obj;
}


static inline
PyObject *
Py_XNewRef(PyObject *obj)
{
    Py_XINCREF(obj);
    return obj;
}

#endif /* PY_VERSION_HEX < 0x030A0000 */


static inline
void
py_clear_ref(PyObject **obj)
{
    PyObject *tmp;

    if ((tmp = *obj) != NULL) {
        *obj = NULL;
        Py_DECREF(tmp);
    }
}


/*
 * NOTE: This implementation is valid for CPython only!
 */
static inline
int
py_object_is(PyObject *obj1, PyObject *obj2)
{
    return (obj1 == obj2);
}


/*
 * NOTE: This implementation is valid for CPython only!
 */
static inline
int
py_object_isnot(PyObject *obj1, PyObject *obj2)
{
    return (obj1 != obj2);
}

#endif
