#!/usr/bin/env python
# -*- coding: utf-8 -*-

import re
import os
import sys
try:
    from setuptools import setup
except ImportError:
    from distutils.core import setup


if (sys.version_info[0] < 2) or \
        ((sys.version_info[0] == 2) and (sys.version_info[1] < 6)):
    raise ValueError("Need at least Python 2.6")


pkg_root = os.path.dirname(__file__)

_version_re = re.compile(br"^\s*__version__\s*=\s*(\"|')(.*)\1\s*(#.*)?$",
                         re.MULTILINE)

with open(os.path.join(pkg_root, "configmix", "__init__.py"), "rb") as vf:
    version = _version_re.search(vf.read()).group(2).decode("utf-8")

with open(os.path.join(pkg_root, "README.txt"), "rt") as rf:
    long_description = rf.read()

aws_requirements = [
    "requests",
]

yaml_requirements = [
    "PyYAML>=3.0,<6",
]

toml_requirements = [
    "toml>=0.10",
]

all_requirements = []
all_requirements.extend(aws_requirements)
all_requirements.extend(yaml_requirements)
all_requirements.extend(toml_requirements)

setup(
    name="ConfigMix",
    version=version,
    author="Franz Glasner",
    license="BSD 3-Clause License",
    url="https://pypi.dom66.de/simple/configmix/",
    description="Library for extended configuration files",
    long_description=long_description,
    packages=["configmix",
              "configmix.extras"],
    include_package_data=False,
    zip_safe=True,
    platforms="any",
    classifiers=[
        "Development Status :: 5 - Production/Stable",
        "Environment :: Console",
        "Intended Audience :: Developers",
        "License :: OSI Approved :: BSD License",
        "Operating System :: OS Independent",
        "Programming Language :: Python",
        "Programming Language :: Python :: 2.6",
        "Programming Language :: Python :: 2.7",
        "Programming Language :: Python :: 3",
        "Topic :: Software Development :: Libraries :: Python Modules"
    ],
    python_requires=">=2.6",
    extras_require={
        "aws" : aws_requirements,        
        "toml": toml_requirements,
        "yaml": yaml_requirements,
        "all" : all_requirements,
    },
    tests_require=all_requirements,
)
