# -*- coding: utf-8 -*-

from __future__ import print_function

import os
import sys
import timeit

sys.path.insert(
    0,
    os.path.abspath(
        os.path.normpath(os.path.join(os.path.dirname(__file__), ".."))))


opts = sys.argv[1:]
all = not opts or "all" in opts

setup = """
import os

import configmix
import configmix.config

TESTDATADIR = os.path.join(
    os.path.abspath(os.path.dirname(configmix.__file__)),
    "..",
    "tests",
    "data")

unquote = configmix.unquote
quote = configmix.quote
pathstr2path = configmix.pathstr2path

cfg = configmix.load(os.path.join(TESTDATADIR, "conf_perf.py"))

se = u""
s1 = u"abc.def.hij"

"""


num = 1000000
num_quote = 1 * num

if all or "quote" in opts or "unquote" in opts or "path" in opts:
    print("unquote/nothing/split: %.4f" % timeit.timeit('a = tuple([unquote(vp) for vp in u"abc.def.hij".split(configmix.config._HIER_SEPARATOR)])', setup=setup, number=num_quote))
    print("unquote/yes/split: %.4f" % timeit.timeit('a = [unquote(vp) for vp in u"ab%x20.def.h%x2ej".split(configmix.config._HIER_SEPARATOR)]', setup=setup, number=num_quote))
    print("unquote/nothing/no-split: %.4f" % timeit.timeit('a = [unquote(vp) for vp in (u"abc," u"def", u"hij")]', setup=setup, number=num_quote))
    print("unquote/yes/no-split: %.4f" % timeit.timeit('a = [unquote(vp) for vp in (u"ab%x20", u"def", u"h%x2ej")]', setup=setup, number=num_quote))
    print("pathstr2path/non-empty: %.4f" % timeit.timeit('a = pathstr2path(s1)', setup=setup, number=num_quote))
    print("pathstr2path/empty: %.4f" % timeit.timeit('a = pathstr2path(se)', setup=setup, number=num_quote))    
    print("quote/nothing: %.4f" % timeit.timeit('a = [quote(vp) for vp in (u"abc", u"def", u"hij")]', setup=setup, number=num_quote))
    print("quote/yes: %.4f" % timeit.timeit('a = [quote(vp) for vp in (u"ab:c", u"def", u"h.ij")]', setup=setup, number=num_quote))
    print("="*50)

if all or "default" in opts or "non-existing" in opts:
    print("default: %.4f" % timeit.timeit('cfg.getvarl(u"tree1", u"yyy", default=None)', setup=setup, number=num))
    print("default: %.4f" % timeit.timeit('cfg.getvarl_s(u"tree1", u"yyy", default=None)', setup=setup, number=num))
    print("default: %.4f" % timeit.timeit('cfg.getvar(u"tree1.yyy", default=None)', setup=setup, number=num))
    print("default: %.4f" % timeit.timeit('cfg.getvar_s(u"tree1.yyy", default=None)', setup=setup, number=num))
    print("-"*50)

if all or "simple-string" in opts:
    print("simple-string: %.4f" % timeit.timeit('cfg.getvarl(u"tree1", u"tree2", "key4")', setup=setup, number=num))
    print("simple-string: %.4f" % timeit.timeit('cfg.getvarl_s(u"tree1", u"tree2", "key4")', setup=setup, number=num))
    print("simple-string: %.4f" % timeit.timeit('cfg.getvar(u"tree1.tree2.key4")', setup=setup, number=num))
    print("simple-string: %.4f" % timeit.timeit('cfg.getvar_s(u"tree1.tree2.key4")', setup=setup, number=num))
    print("-"*50)

if all or "expand-string-one" in opts:
    print("expand-string-one: %.4f" % timeit.timeit('cfg.getvarl(u"tree1", u"tree2", "key11")', setup=setup, number=num))
    print("expand-string-one: %.4f" % timeit.timeit('cfg.getvarl_s(u"tree1", u"tree2", "key11")', setup=setup, number=num))
    print("expand-string-one: %.4f" % timeit.timeit('cfg.getvar(u"tree1.tree2.key11")', setup=setup, number=num))
    print("expand-string-one: %.4f" % timeit.timeit('cfg.getvar_s(u"tree1.tree2.key11")', setup=setup, number=num))
    print("-"*50)

if all or "expand-string-one-noncached" in opts:
    print("expand-string-one-noncached: %.4f" % timeit.timeit('cfg.getvarl(u"tree1", u"tree2", "key12")', setup=setup, number=num))
    print("expand-string-one-noncached: %.4f" % timeit.timeit('cfg.getvarl_s(u"tree1", u"tree2", "key12")', setup=setup, number=num))
    print("expand-string-one-noncached: %.4f" % timeit.timeit('cfg.getvar(u"tree1.tree2.key12")', setup=setup, number=num))
    print("expand-string-one-noncached: %.4f" % timeit.timeit('cfg.getvar_s(u"tree1.tree2.key12")', setup=setup, number=num))
    print("-"*50)    

if all or "expand-string-many" in opts:
    print("expand-string-many: %.4f" % timeit.timeit('cfg.getvarl(u"tree1", u"tree2", "key10")', setup=setup, number=num))
    print("expand-string-many: %.4f" % timeit.timeit('cfg.getvarl_s(u"tree1", u"tree2", "key10")', setup=setup, number=num))
    print("expand-string-many: %.4f" % timeit.timeit('cfg.getvar(u"tree1.tree2.key10")', setup=setup, number=num))
    print("expand-string-many: %.4f" % timeit.timeit('cfg.getvar_s(u"tree1.tree2.key10")', setup=setup, number=num))
    print("-"*50)

if all or "expand-string-many-noncached" in opts:
    print("expand-string-many-noncached: %.4f" % timeit.timeit('cfg.getvarl(u"tree1", u"tree2", u"key13")', setup=setup, number=num))
    print("expand-string-many-noncached: %.4f" % timeit.timeit('cfg.getvarl_s(u"tree1", u"tree2", u"key13")', setup=setup, number=num))
    print("expand-string-many-noncached: %.4f" % timeit.timeit('cfg.getvar(u"tree1.tree2.key13")', setup=setup, number=num))
    print("expand-string-many-noncached: %.4f" % timeit.timeit('cfg.getvar_s(u"tree1.tree2.key13")', setup=setup, number=num))
    print("-"*50)    

if all or "expand-list" in opts:
    print("expand-list: %.4f" % timeit.timeit('cfg.getvarl(u"tree1", u"tree2", "key8")', setup=setup, number=num))
    print("expand-list: %.4f" % timeit.timeit('cfg.getvarl_s(u"tree1", u"tree2", "key8")', setup=setup, number=num))
    print("expand-list: %.4f" % timeit.timeit('cfg.getvar(u"tree1.tree2.key8")', setup=setup, number=num))
    print("expand-list: %.4f" % timeit.timeit('cfg.getvar_s(u"tree1.tree2.key8")', setup=setup, number=num))
    print("-"*50)
