# -*- coding: utf-8 -*-

from __future__ import print_function

import os
import sys
import timeit

sys.path.insert(
    0,
    os.path.abspath(
        os.path.normpath(os.path.join(os.path.dirname(__file__), ".."))))

setup = """
import os

import configmix

TESTDATADIR = os.path.join(
    os.path.abspath(os.path.dirname(configmix.__file__)),
    "..",
    "tests",
    "data")

cfg = configmix.load(os.path.join(TESTDATADIR, "conf_perf.py"))

"""


num = 1000000

print("xxx: %.3f" % timeit.timeit('cfg.getvarl(u"tree1", u"yyy", default=None)', setup=setup, number=num))
print("xxx: %.3f" % timeit.timeit('cfg.getvarl_s(u"tree1", u"yyy", default=None)', setup=setup, number=num))
print("xxx: %.3f" % timeit.timeit('cfg.getvar(u"tree1.yyy", default=None)', setup=setup, number=num))
print("xxx: %.3f" % timeit.timeit('cfg.getvar_s(u"tree1.yyy", default=None)', setup=setup, number=num))

print("xxx: %.3f" % timeit.timeit('cfg.getvarl(u"tree1", u"tree2", "key4")', setup=setup, number=num))
print("xxx: %.3f" % timeit.timeit('cfg.getvarl_s(u"tree1", u"tree2", "key4")', setup=setup, number=num))
print("xxx: %.3f" % timeit.timeit('cfg.getvar(u"tree1.tree2.key4")', setup=setup, number=num))
print("xxx: %.3f" % timeit.timeit('cfg.getvar_s(u"tree1.tree2.key4")', setup=setup, number=num))

print("xxx: %.3f" % timeit.timeit('cfg.getvarl(u"tree1", u"tree2", "key10")', setup=setup, number=num))
print("xxx: %.3f" % timeit.timeit('cfg.getvarl_s(u"tree1", u"tree2", "key10")', setup=setup, number=num))
print("xxx: %.3f" % timeit.timeit('cfg.getvar(u"tree1.tree2.key10")', setup=setup, number=num))
print("xxx: %.3f" % timeit.timeit('cfg.getvar_s(u"tree1.tree2.key10")', setup=setup, number=num))

print("xxx: %.3f" % timeit.timeit('cfg.getvarl(u"tree1", u"tree2", "key8")', setup=setup, number=num))
print("xxx: %.3f" % timeit.timeit('cfg.getvarl_s(u"tree1", u"tree2", "key8")', setup=setup, number=num))
print("xxx: %.3f" % timeit.timeit('cfg.getvar(u"tree1.tree2.key8")', setup=setup, number=num))
print("xxx: %.3f" % timeit.timeit('cfg.getvar_s(u"tree1.tree2.key8")', setup=setup, number=num))

print("xxx: %.3f" % timeit.timeit('cfg.getvarl(u"tree1", u"tree2", "key11")', setup=setup, number=num))
print("xxx: %.3f" % timeit.timeit('cfg.getvarl_s(u"tree1", u"tree2", "key11")', setup=setup, number=num))
print("xxx: %.3f" % timeit.timeit('cfg.getvar(u"tree1.tree2.key11")', setup=setup, number=num))
print("xxx: %.3f" % timeit.timeit('cfg.getvar_s(u"tree1.tree2.key11")', setup=setup, number=num))

