# -*- coding: utf-8 -*-
#-
# :Copyright: (c) 2018, Franz Glasner. All rights reserved.
# :License:   3-clause BSD. See LICENSE.txt for details.
#-
"""Read JSON-style configuration files.

"""

from __future__ import division, absolute_import, print_function

import io
import json.decoder


__all__ = ["load"]


def load(filename, encoding="utf-8"):
    """Load a single JSON file with name `filename` and encoding `encoding`.

    .. todo:: Allow comments in JSON files

    .. todo:: Allow all Python string literals

    .. todo:: Use OrderedDict as default mapping implementation (Python 2.7+)

    """
    with io.open(filename, "rt", encoding=encoding) as jsfp:
        decoder = json.decoder.JSONDecoder(
            parse_int=lambda n: int(n, 0),
            strict=False)
        return decoder.decode(jsfp.read())
