# -*- coding: utf-8 -*-

from __future__ import print_function

import os
import sys
import timeit

sys.path.insert(
    0,
    os.path.abspath(
        os.path.normpath(os.path.join(os.path.dirname(__file__), ".."))))

setup = """
import os

import configmix
import configmix.config

TESTDATADIR = os.path.join(
    os.path.abspath(os.path.dirname(configmix.__file__)),
    "..",
    "tests",
    "data")

unquote = configmix.unquote
quote = configmix.quote

cfg = configmix.load(os.path.join(TESTDATADIR, "conf_perf.py"))

"""


num = 1000000

print("unquote/nothing: %.3f" % timeit.timeit('a = [unquote(vp) for vp in u"abc.def.hij".split(configmix.config._HIER_SEPARATOR)]', setup=setup, number=num))
print("unquote/yes: %.3f" % timeit.timeit('a = [unquote(vp) for vp in u"ab%x20.def.h%x2ej".split(configmix.config._HIER_SEPARATOR)]', setup=setup, number=num))
print("quote/nothing: %.3f" % timeit.timeit('a = [quote(vp) for vp in (u"abc", u"def", u"hij")]', setup=setup, number=num))
print("quote/yes: %.3f" % timeit.timeit('a = [quote(vp) for vp in (u"ab:c", u"def", u"h.ij")]', setup=setup, number=num))

print("="*78)

print("xxx: %.3f" % timeit.timeit('cfg.getvarl(u"tree1", u"yyy", default=None)', setup=setup, number=num))
print("xxx: %.3f" % timeit.timeit('cfg.getvarl_s(u"tree1", u"yyy", default=None)', setup=setup, number=num))
print("xxx: %.3f" % timeit.timeit('cfg.getvar(u"tree1.yyy", default=None)', setup=setup, number=num))
print("xxx: %.3f" % timeit.timeit('cfg.getvar_s(u"tree1.yyy", default=None)', setup=setup, number=num))

print("xxx: %.3f" % timeit.timeit('cfg.getvarl(u"tree1", u"tree2", "key4")', setup=setup, number=num))
print("xxx: %.3f" % timeit.timeit('cfg.getvarl_s(u"tree1", u"tree2", "key4")', setup=setup, number=num))
print("xxx: %.3f" % timeit.timeit('cfg.getvar(u"tree1.tree2.key4")', setup=setup, number=num))
print("xxx: %.3f" % timeit.timeit('cfg.getvar_s(u"tree1.tree2.key4")', setup=setup, number=num))

print("xxx: %.3f" % timeit.timeit('cfg.getvarl(u"tree1", u"tree2", "key10")', setup=setup, number=num))
print("xxx: %.3f" % timeit.timeit('cfg.getvarl_s(u"tree1", u"tree2", "key10")', setup=setup, number=num))
print("xxx: %.3f" % timeit.timeit('cfg.getvar(u"tree1.tree2.key10")', setup=setup, number=num))
print("xxx: %.3f" % timeit.timeit('cfg.getvar_s(u"tree1.tree2.key10")', setup=setup, number=num))

print("xxx: %.3f" % timeit.timeit('cfg.getvarl(u"tree1", u"tree2", "key8")', setup=setup, number=num))
print("xxx: %.3f" % timeit.timeit('cfg.getvarl_s(u"tree1", u"tree2", "key8")', setup=setup, number=num))
print("xxx: %.3f" % timeit.timeit('cfg.getvar(u"tree1.tree2.key8")', setup=setup, number=num))
print("xxx: %.3f" % timeit.timeit('cfg.getvar_s(u"tree1.tree2.key8")', setup=setup, number=num))

print("xxx: %.3f" % timeit.timeit('cfg.getvarl(u"tree1", u"tree2", "key11")', setup=setup, number=num))
print("xxx: %.3f" % timeit.timeit('cfg.getvarl_s(u"tree1", u"tree2", "key11")', setup=setup, number=num))
print("xxx: %.3f" % timeit.timeit('cfg.getvar(u"tree1.tree2.key11")', setup=setup, number=num))
print("xxx: %.3f" % timeit.timeit('cfg.getvar_s(u"tree1.tree2.key11")', setup=setup, number=num))


