from __future__ import print_function
import timeit

setup='''
XGLOBAL= 5
class A:
    xclass = 5
    def __init__(self):
        self.xinstance = 5
    def f1(self):
        xlocal = 5
        x = self.xinstance
    def f2(self):
        xlocal = 5
        x = A.xclass
    def f3(self):
        xlocal = 5
        x = XGLOBAL
    def f4(self):
        xlocal = 5
        x = xlocal
    def f5(self):
        xlocal = 5
        x = self.xclass
a = A()
'''
num = 300000000
num = 90000000
print('access via instance variable: %.3f' % timeit.timeit('a.f1()', setup=setup, number=num) )
print('access via class variable (via classname): %.3f' % timeit.timeit('a.f2()', setup=setup, number=num) )
print('access via class variable (via self): %.3f' % timeit.timeit('a.f5()', setup=setup, number=num) )
print('access via module variable: %.3f' % timeit.timeit('a.f3()', setup=setup, number=num) )
print('access via local variable: %.3f' % timeit.timeit('a.f4()', setup=setup, number=num) )
