# -*- coding: utf-8 -*-
r"""Some minimal compatibility between Python2 and Python3

"""

from __future__ import division, absolute_import, print_function

import sys
import locale


__all__ = ["PY2",
           "text_to_native_os_str",
           "native_os_str_to_text"]


PY2 = sys.version_info[0] <= 2


if PY2:

    _OS_ENCODING = locale.getpreferredencoding()

    def text_to_native_os_str(s, encoding=None):
        if isinstance(s, unicode):
            return s.encode(encoding or _OS_ENCODING)
        else:
            return s


    def native_os_str_to_text(s, encoding=None):
        return s.decode(encoding or _OS_ENCODING)

else:

    def text_to_native_os_str(s, encoding=None):
        return s


    def native_os_str_to_text(s, encoding=None):
        return s
