#!/usr/bin/env python
# -*- coding: utf-8 -*-

import re
import os
import sys
try:
    from setuptools import setup
except ImportError:
    from distutils.core import setup


if (sys.version_info[0] < 2) or \
        ((sys.version_info[0] == 2) and (sys.version_info[1] < 7)):
    raise ValueError("Need at least Python 2.7")


pkg_root = os.path.dirname(__file__)

_version_re = re.compile(br"^\s*__version__\s*=\s*(\"|')(.*)\1\s*(#.*)?$",
                         re.MULTILINE)

with open(os.path.join(pkg_root, "_cutils.py"), "rb") as vf:
    version = _version_re.search(vf.read()).group(2).decode("utf-8")


setup(
    name="py-cutils",
    version=version,
    author="Franz Glasner",
    license="BSD 3-Clause License",
    url="https://pypi.dom66.de/simple/py-cutils/",
    description="Pure Python implementation of some coreutils",
    long_description="Pure Python implementation of some coreutils",
    py_modules=["_cutils",
                "shasum",],
    include_package_data=False,
    zip_safe=True,
    platforms="any",
    classifiers=[
        "Development Status :: 5 - Production/Stable",
        "Environment :: Console",
        "Intended Audience :: Developers",
        "Intended Audience :: System Administrators",
        "License :: OSI Approved :: BSD License",
        "Operating System :: OS Independent",
        "Programming Language :: Python",
        "Programming Language :: Python :: 2.7",
        "Programming Language :: Python :: 3",
        "Topic :: System",
        "Topic :: Utilities",
    ],
    python_requires=">=2.7",
    entry_points = {
        "console_scripts": [
            "py-shasum=shasum:main",
        ]
    }
)
