# -*- coding: utf-8 -*-
# :-
# SPDX-FileCopyrightText: © 2024-2025 Franz Glasner
# SPDX-License-Identifier: BSD-3-Clause
# :-
r"""Context manager extensions and compatibility.

"""

from __future__ import print_function, absolute_import


__all__ = ["nullcontext"]


try:
    from contextlib import nullcontext
except ImportError:
    class nullcontext(object):

        """Compatibility implementation for systems that are missing yet
        a standard :class:`contextlib.nullcontext`.

        """

        __slots__ = ("thing", )

        def __init__(self, thing=None):
            self.thing = thing

        def __enter__(self):
            return self.thing

        def __exit__(self, *args, **kwds):
            pass
