#!/usr/bin/env python
# -*- coding: utf-8 -*-

import re
import os
import sys
try:
    from setuptools import setup
except ImportError:
    from distutils.core import setup


if (sys.version_info[0] < 2) or \
        ((sys.version_info[0] == 2) and (sys.version_info[1] < 7)):
    raise ValueError("Need at least Python 2.7")

pkg_root = os.path.dirname(__file__)

_version_re = re.compile(br"^\s*__version__\s*=\s*(\"|')(.*)\1\s*(#.*)?$",
                         re.MULTILINE)

with open(os.path.join(pkg_root, "cutils", "__init__.py"), "rb") as vf:
    version = _version_re.search(vf.read()).group(2).decode("utf-8")

with open(os.path.join(pkg_root, "README.txt"), "rt") as rf:
    long_description = rf.read()

setup(
    name="py-cutils",
    version=version,
    author="Franz Glasner",
    license="""BSD 3-Clause "New" or "Revised" License""",
    url="https://pypi.dom66.de/simple/py-cutils/",
    description="Pure Python implementation of some coreutils with some extensions",
    long_description=long_description,
    packages=["cutils", "cutils.util"],
    include_package_data=False,
    zip_safe=True,
    platforms="any",
    classifiers=[
        "Development Status :: 5 - Production/Stable",
        "Environment :: Console",
        "Intended Audience :: Developers",
        "Intended Audience :: End Users/Desktop",
        "Intended Audience :: System Administrators",
        "License :: OSI Approved :: BSD License",
        "Operating System :: OS Independent",
        "Programming Language :: Python :: 2.7",
        "Programming Language :: Python :: 3",
        "Topic :: System",
        "Topic :: Utilities",
    ],
    python_requires=">=2.7",
    entry_points={
        "console_scripts": [
            "py-dos2unix=cutils.dos2unix:main",
            "py-shasum=cutils.shasum:main",
            "py-treesum=cutils.treesum:main",
        ]
    }
)
