# -*- coding: utf-8 -*-
# :-
# :Copyright: (c) 2020-2024 Franz Glasner
# :License:   BSD-3-Clause
# :-
r"""Context manager extensions and compatibility.

"""

__all__ = ["nullcontext"]


try:
    from contextlib import nullcontext
except ImportError:
    class nullcontext(object):

        """Compatibility implementation for systems that are missing yet
        a standard :class:`contextlib.nullcontext`.

        """

        __slots__ = ("thing", )

        def __init__(self, thing=None):
            self.thing = thing

        def __enter__(self):
            return self.thing

        def __exit__(self, *args, **kwds):
            pass
