# -*- coding: utf-8 -*-
r"""Unit tests for :mod:`cutils.util.glob`

"""

from __future__ import absolute_import, print_function

import _test_setup    # noqa: F401 imported but unused

import sys
import unittest

from cutils.util.glob import CharIter


class TestCharIter(unittest.TestCase):

    def test_transitive_iter(self):
        it = CharIter("1234")
        self.assertIs(iter(it), it)

    def test_native_str(self):
        it = CharIter("1234")
        chars = []
        for c in it:
            chars.append(c)
        self.assertEqual("1234", "".join(chars))

    def test_unicode_str(self):
        it = CharIter(u"1234")
        chars = []
        for c in it:
            chars.append(c)
        self.assertEqual(u"1234", "".join(chars))

    def test_byte_str(self):
        it = CharIter(b"1234")
        chars = []
        for c in it:
            chars.append(c)
        self.assertEqual(b"1234", b"".join(chars))

    def test_peek_exhausted(self):
        it = CharIter("1234")
        for _ in it:
            pass
        self.assertIsNone(it.peek())

    def test_peek_first(self):
        it = CharIter("1234")
        self.assertEqual("1", it.peek())
        chars = "".join(it)
        self.assertEqual("1234", chars)
        self.assertIsNone(it.peek())

    def test_peek_from_second(self):
        it = CharIter("1234")
        self.assertEqual("1", it.peek())
        self.assertEqual("1", next(it))
        self.assertEqual("2", it.peek())
        chars = "".join(it)
        self.assertEqual("234", chars)
        self.assertIsNone(it.peek())


if __name__ == "__main__":
    sys.exit(unittest.main())
