# -*- coding: utf-8 -*-
# :-
# :Copyright: (c) 2020-2025 Franz Glasner
# :License:   BSD-3-Clause
# :-
r"""Common constants and compatibility definitions.

"""

__all__ = ["PY2",
           "PATH_TYPES",
           "READ_CHUNK_SIZE",
           "MAX_AUTO_MAP_SIZE",
           "MAP_WINDOW_SIZE"
           ]


import sys
try:
    import pathlib
except ImportError:
    pathlib = None


PY2 = sys.version_info[0] < 3

if PY2:
    PATH_TYPES = (unicode, str)    # noqa: F821 (undefined name 'unicode')
else:
    if pathlib:
        PATH_TYPES = (str, bytes, pathlib.Path)
    else:
        PATH_TYPES = (str, bytes)

READ_CHUNK_SIZE = 2 * 1024 * 1024    # like BUFSIZE_MAX on FreeBSD
MAX_AUTO_MAP_SIZE = 8 * 1024 * 1024
MAP_WINDOW_SIZE = MAX_AUTO_MAP_SIZE  # do not totally trash memory on big files
