--- plugins/pypy/pypy_setup.py.orig	2024-10-26 11:39:02.000000000 +0200
+++ plugins/pypy/pypy_setup.py	2025-03-15 12:13:38.474221000 +0100
@@ -31,6 +31,7 @@
 extern void (*uwsgi_pypy_hook_pythonpath)(char *);
 extern void (*uwsgi_pypy_hook_request)(struct wsgi_request *);
 extern void (*uwsgi_pypy_post_fork_hook)(void);
+extern void (*uwsgi_pypy_hook_atexit)(void);
 '''
 
 # here we load CFLAGS and uwsgi.h from the binary
@@ -48,8 +49,8 @@
 uwsgi_defines = []
 uwsgi_cflags = ffi.string(lib0.uwsgi_get_cflags()).split()
 for cflag in uwsgi_cflags:
-    if cflag.startswith(b'-D'):
-        line = cflag[2:].decode()
+    if cflag.startswith('-D'):
+        line = cflag[2:]
         if '=' in line:
             (key, value) = line.split('=', 1)
             uwsgi_cdef.append('#define %s ...' % key)
@@ -59,6 +60,12 @@
             uwsgi_defines.append('#define %s 1' % line)
 uwsgi_dot_h = ffi.string(lib0.uwsgi_get_dot_h())
 
+#
+# Replace #include <pcre.h> on FreeBSD because it is found on a non-standard
+# location for cffi.
+#
+uwsgi_dot_h = uwsgi_dot_h.replace('#include <pcre.h>', '#include "/usr/local/include/pcre.h"')
+
 # uwsgi definitions
 cdefines = '''
 %s
@@ -110,6 +117,8 @@
         uint64_t running_time;
         uint64_t avg_response_time;
         uint64_t tx;
+
+        int hijacked;
         ...;
 };
 
@@ -164,11 +173,14 @@
         struct wsgi_request *wsgi_req;
 
         struct uwsgi_plugin *p[];
+
+        int skip_atexit_teardown;
+
         ...;
 };
 extern struct uwsgi_server uwsgi;
 
-extern struct uwsgi_plugin pypy_plugin;
+extern struct uwsgi_plugin pypy2_plugin;
 
 extern const char *uwsgi_pypy_version;
 
@@ -269,9 +281,9 @@
 %s
 
 extern struct uwsgi_server uwsgi;
-extern struct uwsgi_plugin pypy_plugin;
+extern struct uwsgi_plugin pypy2_plugin;
 %s
-''' % ('\n'.join(uwsgi_defines), uwsgi_dot_h.decode(), hooks)
+''' % ('\n'.join(uwsgi_defines), uwsgi_dot_h, hooks)
 
 ffi.cdef(cdefines)
 lib = ffi.verify(cverify)
@@ -286,7 +298,7 @@
 
 # fix argv if needed
 if len(sys.argv) == 0:
-    sys.argv.insert(0, ffi.string(lib.uwsgi_binary_path()).decode())
+    sys.argv.insert(0, ffi.string(lib.uwsgi_binary_path()))
 
 
 @ffi.callback("void(char *)")
@@ -305,7 +317,7 @@
     load a wsgi module
     """
     global wsgi_application
-    m = ffi.string(module).decode()
+    m = ffi.string(module)
     c = 'application'
     if ':' in m:
         m, c = m.split(':')
@@ -324,7 +336,7 @@
     global wsgi_application
     w = ffi.string(filename)
     c = 'application'
-    mod = imp.load_source('uwsgi_file_wsgi', w.decode())
+    mod = imp.load_source('uwsgi_file_wsgi', w)
     wsgi_application = getattr(mod, c)
 
 
@@ -334,7 +346,7 @@
     load a .ini paste app
     """
     global wsgi_application
-    c = ffi.string(config).decode()
+    c = ffi.string(config)
     if c.startswith('config:'):
         c = c[7:]
     if c[0] != '/':
@@ -363,11 +375,46 @@
     """
     add an item to the pythonpath
     """
-    path = ffi.string(item).decode()
+    path = ffi.string(item)
     sys.path.append(path)
     print("added %s to pythonpath" % path)
 
 
+@ffi.callback("void()")
+def uwsgi_pypy_atexit():
+    """
+    .atexit handler implementation
+
+    Modelled after python_plugin.c
+    """
+    mywid = lib.uwsgi.mywid
+    if mywid > 0:
+        # if hijacked do not run atexit hooks
+        if lib.uwsgi.workers[mywid].hijacked:
+            return
+        # if busy do not run atexit hooks
+        if lib.uwsgi_worker_is_busy(mywid):
+            return
+        # managing atexit in async mode is a real pain...skip it for now
+        if getattr(lib.uwsgi, "async") > 0:
+            return
+
+    import uwsgi
+    uahandler = getattr(uwsgi, "atexit", None)
+    if callable(uahandler):
+        uahandler()
+
+    if lib.uwsgi.skip_atexit_teardown:
+        return
+
+    import atexit
+    aefn = getattr(atexit, "_run_exitfuncs", None)
+    if callable(aefn):
+        aefn()
+    else:
+        print("!!! atexit._run_exitfuncs() not found !!!")
+
+
 class WSGIfilewrapper(object):
     """
     class implementing wsgi.file_wrapper
@@ -470,17 +517,15 @@
     def start_response(status, headers, exc_info=None):
         if exc_info:
             traceback.print_exception(*exc_info)
-        status = status.encode()
         lib.uwsgi_response_prepare_headers(wsgi_req, ffi.new("char[]", status), len(status))
         for hh in headers:
-            hh = (hh[0].encode(), hh[1].encode())
             lib.uwsgi_response_add_header(wsgi_req, ffi.new("char[]", hh[0]), len(hh[0]), ffi.new("char[]", hh[1]), len(hh[1]))
         return writer
 
     environ = {}
     iov = wsgi_req.hvec
     for i in range(0, wsgi_req.var_cnt, 2):
-        environ[ffi.string(ffi.cast("char*", iov[i].iov_base), iov[i].iov_len).decode()] = ffi.string(ffi.cast("char*", iov[i+1].iov_base), iov[i+1].iov_len).decode()
+        environ[ffi.string(ffi.cast("char*", iov[i].iov_base), iov[i].iov_len)] = ffi.string(ffi.cast("char*", iov[i+1].iov_base), iov[i+1].iov_len)
 
     environ['wsgi.version'] = (1, 0)
     scheme = 'http'
@@ -525,6 +570,7 @@
 lib.uwsgi_pypy_hook_pythonpath = uwsgi_pypy_pythonpath
 lib.uwsgi_pypy_hook_request = uwsgi_pypy_wsgi_handler
 lib.uwsgi_pypy_post_fork_hook = uwsgi_pypy_post_fork_hook
+lib.uwsgi_pypy_hook_atexit = uwsgi_pypy_atexit
 
 """
 Here we define the "uwsgi" virtual module
@@ -539,7 +585,7 @@
 def uwsgi_pypy_uwsgi_register_signal(signum, kind, handler):
     cb = ffi.callback('void(int)', handler)
     uwsgi_gc.append(cb)
-    if lib.uwsgi_register_signal(signum, ffi.new("char[]", kind), cb, lib.pypy_plugin.modifier1) < 0:
+    if lib.uwsgi_register_signal(signum, ffi.new("char[]", kind), cb, lib.pypy2_plugin.modifier1) < 0:
         raise Exception("unable to register signal %d" % signum)
 uwsgi.register_signal = uwsgi_pypy_uwsgi_register_signal
 
@@ -564,7 +610,7 @@
     rpc_func = uwsgi_pypy_RPC(func)
     cb = ffi.callback("int(int, char*[], int[], char**)", rpc_func)
     uwsgi_gc.append(cb)
-    if lib.uwsgi_register_rpc(ffi.new("char[]", name), ffi.addressof(lib.pypy_plugin), argc, cb) < 0:
+    if lib.uwsgi_register_rpc(ffi.new("char[]", name), ffi.addressof(lib.pypy2_plugin), argc, cb) < 0:
         raise Exception("unable to register rpc func %s" % name)
 uwsgi.register_rpc = uwsgi_pypy_uwsgi_register_rpc
 
@@ -1069,7 +1115,7 @@
 
 
 def uwsgi_pypy_setup_continulets():
-    if lib.uwsgi["async"] < 1:
+    if getattr(lib.uwsgi, "async") < 1:
         raise Exception("pypy continulets require async mode !!!")
     lib.uwsgi.schedule_to_main = uwsgi_pypy_continulet_switch
     lib.uwsgi.schedule_to_req = uwsgi_pypy_continulet_schedule
