--- plugins/pypy/pypy_setup.py.orig	2024-10-26 09:39:02 UTC
+++ plugins/pypy/pypy_setup.py
@@ -31,6 +31,7 @@ extern void (*uwsgi_pypy_post_fork_hook)(void);
 extern void (*uwsgi_pypy_hook_pythonpath)(char *);
 extern void (*uwsgi_pypy_hook_request)(struct wsgi_request *);
 extern void (*uwsgi_pypy_post_fork_hook)(void);
+extern void (*uwsgi_pypy_hook_atexit)(void);
 '''
 
 # here we load CFLAGS and uwsgi.h from the binary
@@ -57,8 +58,14 @@ for cflag in uwsgi_cflags:
         else:
             uwsgi_cdef.append('#define %s ...' % line)
             uwsgi_defines.append('#define %s 1' % line)
-uwsgi_dot_h = ffi.string(lib0.uwsgi_get_dot_h())
+uwsgi_dot_h = ffi.string(lib0.uwsgi_get_dot_h()).decode()
 
+#
+# Replace #include <pcre.h> on FreeBSD because it is found on a non-standard
+# location for cffi.
+#
+uwsgi_dot_h = uwsgi_dot_h.replace('#include <pcre.h>', '#include "/usr/local/include/pcre.h"')
+
 # uwsgi definitions
 cdefines = '''
 %s
@@ -110,6 +117,8 @@ struct uwsgi_worker {
         uint64_t running_time;
         uint64_t avg_response_time;
         uint64_t tx;
+
+        int hijacked;
         ...;
 };
 
@@ -164,11 +173,14 @@ struct uwsgi_server {
         struct wsgi_request *wsgi_req;
 
         struct uwsgi_plugin *p[];
+
+        int skip_atexit_teardown;
+
         ...;
 };
 extern struct uwsgi_server uwsgi;
 
-extern struct uwsgi_plugin pypy_plugin;
+extern struct uwsgi_plugin pypy3_plugin;
 
 extern const char *uwsgi_pypy_version;
 
@@ -269,9 +281,9 @@ extern struct uwsgi_server uwsgi;
 %s
 
 extern struct uwsgi_server uwsgi;
-extern struct uwsgi_plugin pypy_plugin;
+extern struct uwsgi_plugin pypy3_plugin;
 %s
-''' % ('\n'.join(uwsgi_defines), uwsgi_dot_h.decode(), hooks)
+''' % ('\n'.join(uwsgi_defines), uwsgi_dot_h, hooks)
 
 ffi.cdef(cdefines)
 lib = ffi.verify(cverify)
@@ -368,6 +380,41 @@ def uwsgi_pypy_pythonpath(item):
     print("added %s to pythonpath" % path)
 
 
+@ffi.callback("void()")
+def uwsgi_pypy_atexit():
+    """
+    .atexit handler implementation
+
+    Modelled after python_plugin.c
+    """
+    mywid = lib.uwsgi.mywid
+    if mywid > 0:
+        # if hijacked do not run atexit hooks
+        if lib.uwsgi.workers[mywid].hijacked:
+            return
+        # if busy do not run atexit hooks
+        if lib.uwsgi_worker_is_busy(mywid):
+            return
+        # managing atexit in async mode is a real pain...skip it for now
+        if getattr(lib.uwsgi, "async") > 0:
+            return
+
+    import uwsgi
+    uahandler = getattr(uwsgi, "atexit", None)
+    if callable(uahandler):
+        uahandler()
+
+    if lib.uwsgi.skip_atexit_teardown:
+        return
+
+    import atexit
+    aefn = getattr(atexit, "_run_exitfuncs", None)
+    if callable(aefn):
+        aefn()
+    else:
+        print("!!! atexit._run_exitfuncs() not found !!!")
+
+
 class WSGIfilewrapper(object):
     """
     class implementing wsgi.file_wrapper
@@ -470,17 +517,17 @@ def uwsgi_pypy_wsgi_handler(wsgi_req):
     def start_response(status, headers, exc_info=None):
         if exc_info:
             traceback.print_exception(*exc_info)
-        status = status.encode()
+        status = status.encode("latin1")
         lib.uwsgi_response_prepare_headers(wsgi_req, ffi.new("char[]", status), len(status))
         for hh in headers:
-            hh = (hh[0].encode(), hh[1].encode())
+            hh = (hh[0].encode("latin1"), hh[1].encode("latin1"))
             lib.uwsgi_response_add_header(wsgi_req, ffi.new("char[]", hh[0]), len(hh[0]), ffi.new("char[]", hh[1]), len(hh[1]))
         return writer
 
     environ = {}
     iov = wsgi_req.hvec
     for i in range(0, wsgi_req.var_cnt, 2):
-        environ[ffi.string(ffi.cast("char*", iov[i].iov_base), iov[i].iov_len).decode()] = ffi.string(ffi.cast("char*", iov[i+1].iov_base), iov[i+1].iov_len).decode()
+        environ[ffi.string(ffi.cast("char*", iov[i].iov_base), iov[i].iov_len).decode("latin1")] = ffi.string(ffi.cast("char*", iov[i+1].iov_base), iov[i+1].iov_len).decode("latin1")
 
     environ['wsgi.version'] = (1, 0)
     scheme = 'http'
@@ -525,6 +572,7 @@ lib.uwsgi_pypy_post_fork_hook = uwsgi_pypy_post_fork_h
 lib.uwsgi_pypy_hook_pythonpath = uwsgi_pypy_pythonpath
 lib.uwsgi_pypy_hook_request = uwsgi_pypy_wsgi_handler
 lib.uwsgi_pypy_post_fork_hook = uwsgi_pypy_post_fork_hook
+lib.uwsgi_pypy_hook_atexit = uwsgi_pypy_atexit
 
 """
 Here we define the "uwsgi" virtual module
@@ -539,7 +587,7 @@ def uwsgi_pypy_uwsgi_register_signal(signum, kind, han
 def uwsgi_pypy_uwsgi_register_signal(signum, kind, handler):
     cb = ffi.callback('void(int)', handler)
     uwsgi_gc.append(cb)
-    if lib.uwsgi_register_signal(signum, ffi.new("char[]", kind), cb, lib.pypy_plugin.modifier1) < 0:
+    if lib.uwsgi_register_signal(signum, ffi.new("char[]", kind), cb, lib.pypy3_plugin.modifier1) < 0:
         raise Exception("unable to register signal %d" % signum)
 uwsgi.register_signal = uwsgi_pypy_uwsgi_register_signal
 
@@ -564,7 +612,7 @@ def uwsgi_pypy_uwsgi_register_rpc(name, func, argc=0):
     rpc_func = uwsgi_pypy_RPC(func)
     cb = ffi.callback("int(int, char*[], int[], char**)", rpc_func)
     uwsgi_gc.append(cb)
-    if lib.uwsgi_register_rpc(ffi.new("char[]", name), ffi.addressof(lib.pypy_plugin), argc, cb) < 0:
+    if lib.uwsgi_register_rpc(ffi.new("char[]", name), ffi.addressof(lib.pypy3_plugin), argc, cb) < 0:
         raise Exception("unable to register rpc func %s" % name)
 uwsgi.register_rpc = uwsgi_pypy_uwsgi_register_rpc
 
@@ -1069,7 +1117,7 @@ def uwsgi_pypy_setup_continulets():
 
 
 def uwsgi_pypy_setup_continulets():
-    if lib.uwsgi["async"] < 1:
+    if getattr(lib.uwsgi, "async") < 1:
         raise Exception("pypy continulets require async mode !!!")
     lib.uwsgi.schedule_to_main = uwsgi_pypy_continulet_switch
     lib.uwsgi.schedule_to_req = uwsgi_pypy_continulet_schedule
