--- plugins/pypy/pypy_setup.py.orig	2020-06-16 22:35:02.597340000 +0200
+++ plugins/pypy/pypy_setup.py	2020-06-16 23:41:10.094554000 +0200
@@ -33,6 +33,12 @@
 extern void (*uwsgi_pypy_post_fork_hook)(void);
 '''
 
+
+# Convert a byte string to a native string using the default encoding
+def n(b):
+    return b.decode()
+
+
 # here we load CFLAGS and uwsgi.h from the binary
 defines0 = '''
 char *uwsgi_get_cflags();
@@ -46,7 +52,7 @@
 # basically it build a list of #define from binary CFLAGS
 uwsgi_cdef = []
 uwsgi_defines = []
-uwsgi_cflags = ffi.string(lib0.uwsgi_get_cflags()).split()
+uwsgi_cflags = n(ffi.string(lib0.uwsgi_get_cflags())).split()
 for cflag in uwsgi_cflags:
     if cflag.startswith('-D'):
         line = cflag[2:]
@@ -271,7 +277,7 @@
 extern struct uwsgi_server uwsgi;
 extern struct uwsgi_plugin pypy_plugin;
 %s
-''' % ('\n'.join(uwsgi_defines), uwsgi_dot_h, hooks)
+''' % ('\n'.join(uwsgi_defines), n(uwsgi_dot_h), hooks)
 
 ffi.cdef(cdefines)
 lib = ffi.verify(cverify)
@@ -286,7 +292,7 @@
 
 # fix argv if needed
 if len(sys.argv) == 0:
-    sys.argv.insert(0, ffi.string(lib.uwsgi_binary_path()))
+    sys.argv.insert(0, n(ffi.string(lib.uwsgi_binary_path())))
 
 
 @ffi.callback("void(char *)")
@@ -305,7 +311,7 @@
     load a wsgi module
     """
     global wsgi_application
-    m = ffi.string(module)
+    m = n(ffi.string(module))
     c = 'application'
     if ':' in m:
         m, c = m.split(':')
@@ -322,7 +328,7 @@
     load a mod_wsgi compliant .wsgi file
     """
     global wsgi_application
-    w = ffi.string(filename)
+    w = n(ffi.string(filename))
     c = 'application'
     mod = imp.load_source('uwsgi_file_wsgi', w)
     wsgi_application = getattr(mod, c)
@@ -334,7 +340,7 @@
     load a .ini paste app
     """
     global wsgi_application
-    c = ffi.string(config)
+    c = n(ffi.string(config))
     if c.startswith('config:'):
         c = c[7:]
     if c[0] != '/':
@@ -363,7 +369,7 @@
     """
     add an item to the pythonpath
     """
-    path = ffi.string(item)
+    path = n(ffi.string(item))
     sys.path.append(path)
     print("added %s to pythonpath" % path)
 
@@ -470,15 +476,17 @@
     def start_response(status, headers, exc_info=None):
         if exc_info:
             traceback.print_exception(*exc_info)
+        status = status.encode("latin1")            
         lib.uwsgi_response_prepare_headers(wsgi_req, ffi.new("char[]", status), len(status))
         for hh in headers:
+            hh = (hh[0].encode("latin1"), hh[1].encode("latin1"))
             lib.uwsgi_response_add_header(wsgi_req, ffi.new("char[]", hh[0]), len(hh[0]), ffi.new("char[]", hh[1]), len(hh[1]))
         return writer
 
     environ = {}
     iov = wsgi_req.hvec
     for i in range(0, wsgi_req.var_cnt, 2):
-        environ[ffi.string(ffi.cast("char*", iov[i].iov_base), iov[i].iov_len)] = ffi.string(ffi.cast("char*", iov[i+1].iov_base), iov[i+1].iov_len)
+        environ[ffi.string(ffi.cast("char*", iov[i].iov_base), iov[i].iov_len).decode("latin1")] = ffi.string(ffi.cast("char*", iov[i+1].iov_base), iov[i+1].iov_len).decode("latin1")
 
     environ['wsgi.version'] = (1, 0)
     scheme = 'http'
@@ -598,8 +606,8 @@
 
 def uwsgi_pypy_call(func, *args):
     node = None
-    if '@' in func:
-        (func, node) = func.split('@')
+    if b'@' in func:
+        (func, node) = func.split(b'@')
     return uwsgi_pypy_rpc(node, func, *args)
 uwsgi.call = uwsgi_pypy_call
 
