--- plugins/pypy/pypy_plugin.c.orig	2020-07-09 07:54:09.000000000 +0200
+++ plugins/pypy/pypy_plugin.c	2020-08-04 09:28:14.194761000 +0200
@@ -42,9 +42,10 @@ void (*uwsgi_pypy_hook_paste_loader)(char *);
 void (*uwsgi_pypy_hook_pythonpath)(char *);
 void (*uwsgi_pypy_hook_request)(void *, int);
 void (*uwsgi_pypy_post_fork_hook)(void);
+void (*uwsgi_pypy_hook_atexit)(void);
 
 extern struct uwsgi_server uwsgi;
-struct uwsgi_plugin pypy_plugin;
+struct uwsgi_plugin pypy3_plugin;
 
 static int uwsgi_pypy_init() {
 
@@ -68,26 +69,26 @@ static int uwsgi_pypy_init() {
 		if (upypy.home) {
 			// first try with /bin way:
 #ifdef __CYGWIN__
-                        char *libpath = uwsgi_concat2(upypy.home, "/bin/libpypy-c.dll");
+			char *libpath = uwsgi_concat2(upypy.home, "/bin/libpypy3-c.so");
 #elif defined(__APPLE__)
-                        char *libpath = uwsgi_concat2(upypy.home, "/bin/libpypy-c.dylib");
+			char *libpath = uwsgi_concat2(upypy.home, "/bin/libpypy3-c.so");
 #else
-                        char *libpath = uwsgi_concat2(upypy.home, "/bin/libpypy-c.so");
+			char *libpath = uwsgi_concat2(upypy.home, "/bin/libpypy3-c.so");
 #endif
 			if (uwsgi_file_exists(libpath)) {
-                                upypy.handler = dlopen(libpath, RTLD_NOW | RTLD_GLOBAL);
-                        }
-                        free(libpath);
+				upypy.handler = dlopen(libpath, RTLD_NOW | RTLD_GLOBAL);
+			}
+			free(libpath);
 
 			// fallback to old-style way
 			if (!upypy.handler) {
 			
 #ifdef __CYGWIN__
-                        	char *libpath = uwsgi_concat2(upypy.home, "/libpypy-c.dll");
+				char *libpath = uwsgi_concat2(upypy.home, "/libpypy3-c.so");
 #elif defined(__APPLE__)
-                        	char *libpath = uwsgi_concat2(upypy.home, "/libpypy-c.dylib");
+				char *libpath = uwsgi_concat2(upypy.home, "/libpypy3-c.dylib");
 #else
-                        	char *libpath = uwsgi_concat2(upypy.home, "/libpypy-c.so");
+				char *libpath = uwsgi_concat2(upypy.home, "/libpypy3-c.so");
 #endif
 				if (uwsgi_file_exists(libpath)) {
 					upypy.handler = dlopen(libpath, RTLD_NOW | RTLD_GLOBAL);
@@ -98,11 +99,11 @@ static int uwsgi_pypy_init() {
 		// fallback to standard library search path
 		if (!upypy.handler) {
 #ifdef __CYGWIN__
-			upypy.handler = dlopen("libpypy-c.dll", RTLD_NOW | RTLD_GLOBAL);
+			upypy.handler = dlopen("libpypy3-c.dll", RTLD_NOW | RTLD_GLOBAL);
 #elif defined(__APPLE__)
-			upypy.handler = dlopen("libpypy-c.dylib", RTLD_NOW | RTLD_GLOBAL);
+			upypy.handler = dlopen("libpypy3-c.dylib", RTLD_NOW | RTLD_GLOBAL);
 #else
-			upypy.handler = dlopen("libpypy-c.so", RTLD_NOW | RTLD_GLOBAL);
+			upypy.handler = dlopen("libpypy3-c.so", RTLD_NOW | RTLD_GLOBAL);
 #endif
 		}
 	}
@@ -125,9 +126,9 @@ static int uwsgi_pypy_init() {
 	}
 
 	u_pypy_init_threads = dlsym(upypy.handler, "pypy_init_threads");
-        if (!u_pypy_init_threads) {
-                uwsgi_log("!!! WARNING your libpypy-c does not export pypy_init_threads, multithreading will not work !!!\n");
-        }
+	if (!u_pypy_init_threads) {
+		uwsgi_log("!!! WARNING your libpypy-c does not export pypy_init_threads, multithreading will not work !!!\n");
+	}
 	
 	u_rpython_startup_code();
 
@@ -148,9 +149,9 @@ static int uwsgi_pypy_init() {
 				goto ready;
 			}
 		}
-                uwsgi_log("unable to set pypy home to \"%s\"\n", upypy.home);
+		uwsgi_log("unable to set pypy home to \"%s\"\n", upypy.home);
 		exit(1);
-        }
+	}
 
 ready:
 	u_pypy_execute_source = dlsym(upypy.handler, "pypy_execute_source");
@@ -160,9 +161,9 @@ ready:
 	}
 
 	u_pypy_thread_attach = dlsym(upypy.handler, "pypy_thread_attach");
-        if (!u_pypy_thread_attach) {
-                uwsgi_log("!!! WARNING your libpypy-c does not export pypy_thread_attach, multithreading will not work !!!\n");
-        }
+	if (!u_pypy_thread_attach) {
+		uwsgi_log("!!! WARNING your libpypy-c does not export pypy_thread_attach, multithreading will not work !!!\n");
+	}
 
 	if (upypy.setup) {
 		buffer = uwsgi_open_and_read(upypy.setup, &rlen, 1, NULL);
@@ -233,14 +234,14 @@ static void uwsgi_pypy_preinit_apps() {
 
 static int uwsgi_pypy_request(struct wsgi_request *wsgi_req) {
 	/* Standard WSGI request */
-        if (!wsgi_req->len) {
-                uwsgi_log( "Empty pypy request. skip.\n");
-                return -1;
-        }
+	if (!wsgi_req->len) {
+		uwsgi_log( "Empty pypy request. skip.\n");
+		return -1;
+	}
 
-        if (uwsgi_parse_vars(wsgi_req)) {
-                return -1;
-        }
+	if (uwsgi_parse_vars(wsgi_req)) {
+		return -1;
+	}
 
 	if (uwsgi_pypy_hook_request) {
 		uwsgi_pypy_hook_request(wsgi_req, wsgi_req->async_id);
@@ -266,16 +267,19 @@ static void uwsgi_pypy_init_apps() {
 	}
 }
 
-/*
+
 static void uwsgi_pypy_atexit() {
-	if (pypy_debug_file)
-		fflush(pypy_debug_file);
+	if (!uwsgi_pypy_hook_atexit) {
+		uwsgi_log("!!! Your pypy setup does not define a uwsgi_pypy_atexit !!!\n");	       
+		return;
+	}	     
+	uwsgi_pypy_hook_atexit();
 }
-*/
 
+
 static void uwsgi_opt_pypy_ini_paste(char *opt, char *value, void *foobar) {
-        uwsgi_opt_load_ini(opt, value, NULL);
-        upypy.paste = value;
+	uwsgi_opt_load_ini(opt, value, NULL);
+	upypy.paste = value;
 }
 
 
@@ -332,14 +336,14 @@ static void uwsgi_pypy_post_fork() {
 	pthread_mutex_init(&upypy.attach_thread_lock, NULL);
 	struct uwsgi_string_list *usl = NULL;
 	uwsgi_foreach(usl, upypy.eval_post_fork) {
-                uwsgi_pypy_hook_execute_source(usl->value);
-        }
+		uwsgi_pypy_hook_execute_source(usl->value);
+	}
 	uwsgi_foreach(usl, upypy.exec_post_fork) {
-                size_t rlen = 0;
-                char *buffer = uwsgi_open_and_read(usl->value, &rlen, 1, NULL);
-                uwsgi_pypy_hook_execute_source(buffer);
-                free(buffer);
-        }
+		size_t rlen = 0;
+		char *buffer = uwsgi_open_and_read(usl->value, &rlen, 1, NULL);
+		uwsgi_pypy_hook_execute_source(buffer);
+		free(buffer);
+	}
 
 	if (uwsgi_pypy_post_fork_hook) {
 		uwsgi_pypy_post_fork_hook();
@@ -360,20 +364,20 @@ static int uwsgi_pypy_mule(char *opt) {
 		exit(1);
 	}
 
-        if (uwsgi_endswith(opt, ".py")) {
-                size_t rlen = 0;
-                char *buffer = uwsgi_open_and_read(opt, &rlen, 1, NULL);
-                uwsgi_pypy_hook_execute_source(buffer);
+	if (uwsgi_endswith(opt, ".py")) {
+		size_t rlen = 0;
+		char *buffer = uwsgi_open_and_read(opt, &rlen, 1, NULL);
+		uwsgi_pypy_hook_execute_source(buffer);
 		free(buffer);
-                return 1;
-        }
-        return 0;
+		return 1;
+	}
+	return 0;
 
 }
 
 
-struct uwsgi_plugin pypy_plugin = {
-	.name = "pypy",
+struct uwsgi_plugin pypy3_plugin = {
+	.name = "pypy3",
 	.modifier1 = 0,
 	.on_load = uwsgi_pypy_onload,
 	.init = uwsgi_pypy_init,
@@ -388,4 +392,6 @@ struct uwsgi_plugin pypy_plugin = {
 	.rpc = uwsgi_pypy_rpc,
 	.post_fork = uwsgi_pypy_post_fork,
 	.mule = uwsgi_pypy_mule,
+
+	.atexit = uwsgi_pypy_atexit,
 };
