--- uwsgiconfig.py.orig	2023-12-26 11:13:58 UTC
+++ uwsgiconfig.py
@@ -1494,7 +1494,8 @@ def build_plugin(path, uc, cflags, ldflags, libs, name
             gcc_list.append(path + '/' + cfile)
     for bfile in up.get('BINARY_LIST', []):
         try:
-            binary_link_cmd = "ld -r -b binary -o %s/%s.o %s/%s" % (path, bfile[1], path, bfile[1])
+            # See https://svnweb.freebsd.org/base/vendor/lld/dist-release_80/ELF/Driver.cpp?revision=344173&view=markup
+            binary_link_cmd = "ld -r -b binary %s -o %s/%s.o %s/%s" % (get_default_target_emulation(), path, bfile[1], path, bfile[1])
             print(binary_link_cmd)
             if subprocess.call(binary_link_cmd, shell=True) != 0:
                 raise Exception('unable to link binary file')
@@ -1592,6 +1593,18 @@ def build_plugin(path, uc, cflags, ldflags, libs, name
     print("*** %s plugin built and available in %s ***" % (name, plugin_dest + '.so'))
 
 
+def get_default_target_emulation():
+    """Need a target emulation on FreeBSD (ld, ld.lld when linking binary/raw"""
+    emul = ""
+    if uwsgi_cpu in ("amd64", "x86-64", "x86_64"):
+        emul = "elf_amd64"
+    elif uwsgi_cpu in ("i386", "x86"):
+        emul = "elf_i386"
+    if emul:
+        return "-m %s" % emul
+    return ""
+
+
 def vararg_callback(option, opt_str, value, parser):
     assert value is None
     value = []
@@ -1681,7 +1694,7 @@ if __name__ == "__main__":
         print("*** uWSGI building and linking plugin %s ***" % options.plugin[0])
         build_plugin(options.plugin[0], uc, cflags, ldflags, libs, name)
     elif options.extra_plugin:
-        print("*** uWSGI building and linking plugin from %s ***" % options.extra_plugin[0])
+        print("*** uWSGI building and linking extra plugin from %s ***" % options.extra_plugin[0])
         cflags = os.environ['UWSGI_PLUGINS_BUILDER_CFLAGS'].split() + os.environ.get("CFLAGS", "").split()
         cflags.append('-I.uwsgi_plugins_builder/')
         ldflags = os.environ.get("LDFLAGS", "").split()
