--- uwsgiconfig.py.orig	2022-09-21 14:46:45 UTC
+++ uwsgiconfig.py
@@ -1495,7 +1495,8 @@ def build_plugin(path, uc, cflags, ldflags, libs, name
             gcc_list.append(path + '/' + cfile)
     for bfile in up.get('BINARY_LIST', []):
         try:
-            binary_link_cmd = "ld -r -b binary -o %s/%s.o %s/%s" % (path, bfile[1], path, bfile[1])
+            # See https://svnweb.freebsd.org/base/vendor/lld/dist-release_80/ELF/Driver.cpp?revision=344173&view=markup
+            binary_link_cmd = "ld -r -b binary %s -o %s/%s.o %s/%s" % (get_default_target_emulation(), path, bfile[1], path, bfile[1])
             print(binary_link_cmd)
             if subprocess.call(binary_link_cmd, shell=True) != 0:
                 raise Exception('unable to link binary file')
@@ -1591,6 +1592,17 @@ def build_plugin(path, uc, cflags, ldflags, libs, name
 
     print("build time: %d seconds" % (time.time() - plugin_started_at))
     print("*** %s plugin built and available in %s ***" % (name, plugin_dest + '.so'))
+
+def get_default_target_emulation():
+    """Need a target emulation on FreeBSD (ld, ld.lld when linking binary/raw"""
+    emul = ""
+    if uwsgi_cpu in ("amd64", "x86-64", "x86_64"):
+        emul = "elf_amd64"
+    elif uwsgi_cpu in ("i386", "x86"):
+        emul = "elf_i386"
+    if emul:
+        return "-m %s" % emul
+    return ""
 
 
 def vararg_callback(option, opt_str, value, parser):
