--- uwsgiconfig.py.orig	2024-10-26 09:39:02 UTC
+++ uwsgiconfig.py
@@ -1218,11 +1218,24 @@ class uConf(object):
         uver_min = '0'
         uver_rev = '0'
 
-        if len(uver_dots) > 2:
-            uver_min = uver_dots[2]
+        # fag: handle our PORTVERSION strings properly
+        for plidx, uver_part in enumerate(uver_dots):
+            if uver_part[0].isalpha():
+                assert ((uver_part.startswith("pl") and (uver_part[2:]).isnumeric())
+                        or
+                        (uver_part.startswith("dev") and (uver_part[3:]).isnumeric()))
+                if uver_custom:
+                    uver_custom = ".".join(uver_dots[plidx:]) + "-" + uver_custom
+                else:
+                    uver_custom = ".".join(uver_dots[plidx:])
+                break
+        else:
+            # uWSGI standard
+            if len(uver_dots) > 2:
+                uver_min = uver_dots[2]
 
-        if len(uver_dots) > 3:
-            uver_rev = uver_dots[3]
+            if len(uver_dots) > 3:
+                uver_rev = uver_dots[3]
 
         self.cflags.append('-DUWSGI_VERSION_BASE="' + uver_base + '"')
         self.cflags.append('-DUWSGI_VERSION_MAJOR="' + uver_maj + '"')
@@ -1497,7 +1510,8 @@ def build_plugin(path, uc, cflags, ldflags, libs, name
             gcc_list.append(path + '/' + cfile)
     for bfile in up.get('BINARY_LIST', []):
         try:
-            binary_link_cmd = "ld -r -b binary -o %s/%s.o %s/%s" % (path, bfile[1], path, bfile[1])
+            # See https://svnweb.freebsd.org/base/vendor/lld/dist-release_80/ELF/Driver.cpp?revision=344173&view=markup
+            binary_link_cmd = "ld -r -b binary %s -o %s/%s.o %s/%s" % (get_default_target_emulation(), path, bfile[1], path, bfile[1])
             print(binary_link_cmd)
             if subprocess.call(binary_link_cmd, shell=True) != 0:
                 raise Exception('unable to link binary file')
@@ -1595,6 +1609,19 @@ def build_plugin(path, uc, cflags, ldflags, libs, name
     print("*** %s plugin built and available in %s ***" % (name, plugin_dest + '.so'))
 
 
+
+def get_default_target_emulation():
+    """Need a target emulation on FreeBSD (ld, ld.lld when linking binary/raw"""
+    emul = ""
+    if uwsgi_cpu in ("amd64", "x86-64", "x86_64"):
+        emul = "elf_amd64"
+    elif uwsgi_cpu in ("i386", "x86"):
+        emul = "elf_i386"
+    if emul:
+        return "-m %s" % emul
+    return ""
+
+
 def vararg_callback(option, opt_str, value, parser):
     assert value is None
     value = []
@@ -1684,7 +1711,7 @@ if __name__ == "__main__":
         print("*** uWSGI building and linking plugin %s ***" % options.plugin[0])
         build_plugin(options.plugin[0], uc, cflags, ldflags, libs, name)
     elif options.extra_plugin:
-        print("*** uWSGI building and linking plugin from %s ***" % options.extra_plugin[0])
+        print("*** uWSGI building and linking extra plugin from %s ***" % options.extra_plugin[0])
         cflags = os.environ['UWSGI_PLUGINS_BUILDER_CFLAGS'].split() + os.environ.get("CFLAGS", "").split()
         cflags.append('-I.uwsgi_plugins_builder/')
         ldflags = os.environ.get("LDFLAGS", "").split()
