--- uwsgiconfig.py.orig	2019-02-09 14:48:07 UTC
+++ uwsgiconfig.py
@@ -203,11 +203,12 @@ int main()
 
 def spcall3(cmd):
     p = subprocess.Popen(cmd, shell=True, stdin=open('/dev/null'), stderr=subprocess.PIPE, stdout=subprocess.PIPE)
+    (out, err) = p.communicate()
 
-    if p.wait() == 0:
+    if p.returncode == 0:
         if sys.version_info[0] > 2:
-            return p.stderr.read().rstrip().decode()
-        return p.stderr.read().rstrip()
+            return err.rstrip().decode()
+        return err.rstrip()
     else:
         return None
 
@@ -1457,7 +1458,8 @@ def build_plugin(path, uc, cflags, ldflags, libs, name
             gcc_list.append(path + '/' + cfile)
     for bfile in up.get('BINARY_LIST', []):
         try:
-            binary_link_cmd = "ld -r -b binary -o %s/%s.o %s/%s" % (path, bfile[1], path, bfile[1])
+            # See https://svnweb.freebsd.org/base/vendor/lld/dist-release_80/ELF/Driver.cpp?revision=344173&view=markup
+            binary_link_cmd = "ld -r -b binary %s -o %s/%s.o %s/%s" % (get_default_target_emulation(), path, bfile[1], path, bfile[1])
             print(binary_link_cmd)
             if os.system(binary_link_cmd) != 0:
                 raise Exception('unable to link binary file')
@@ -1550,6 +1552,17 @@ def build_plugin(path, uc, cflags, ldflags, libs, name
 
     print("build time: %d seconds" % (time.time() - plugin_started_at))
     print("*** %s plugin built and available in %s ***" % (name, plugin_dest + '.so'))
+
+def get_default_target_emulation():
+    """Need a target emulation on FreeBSD (ld, ld.lld when linking binary/raw"""
+    emul = ""
+    if uwsgi_cpu in ("amd64", "x86-64", "x86_64"):
+        emul = "elf_amd64"
+    elif uwsgi_cpu in ("i386", "x86"):
+        emul = "elf_i386"
+    if emul:
+        return "-m %s" % emul
+    return ""
 
 def vararg_callback(option, opt_str, value, parser):
     assert value is None
