--- plugins/pypy/pypy_setup.py.orig	2020-06-14 11:50:00.000000000 +0200
+++ plugins/pypy/pypy_setup.py	2020-06-17 22:05:41.175101000 +0200
@@ -33,6 +33,12 @@
 extern void (*uwsgi_pypy_post_fork_hook)(void);
 '''
 
+
+# Convert a byte string to a native string using the default encoding
+def n(b):
+    return b.decode()
+
+
 # here we load CFLAGS and uwsgi.h from the binary
 defines0 = '''
 char *uwsgi_get_cflags();
@@ -46,7 +52,7 @@
 # basically it build a list of #define from binary CFLAGS
 uwsgi_cdef = []
 uwsgi_defines = []
-uwsgi_cflags = ffi.string(lib0.uwsgi_get_cflags()).split()
+uwsgi_cflags = n(ffi.string(lib0.uwsgi_get_cflags())).split()
 for cflag in uwsgi_cflags:
     if cflag.startswith('-D'):
         line = cflag[2:]
@@ -57,8 +63,14 @@
         else:
             uwsgi_cdef.append('#define %s ...' % line)
             uwsgi_defines.append('#define %s 1' % line)
-uwsgi_dot_h = ffi.string(lib0.uwsgi_get_dot_h())
+uwsgi_dot_h = n(ffi.string(lib0.uwsgi_get_dot_h()))
 
+#
+# Replace #include <pcre.h> on FreeBSD because it is found on a non-standard
+# location for cffi.
+#
+uwsgi_dot_h = uwsgi_dot_h.replace('#include <pcre.h>', '#include "/usr/local/include/pcre.h"')
+
 # uwsgi definitions
 cdefines = '''
 %s
@@ -168,7 +180,7 @@
 };
 struct uwsgi_server uwsgi;
 
-struct uwsgi_plugin pypy_plugin;
+struct uwsgi_plugin pypy3_plugin;
 
 const char *uwsgi_pypy_version;
 
@@ -269,7 +281,7 @@
 %s
 
 extern struct uwsgi_server uwsgi;
-extern struct uwsgi_plugin pypy_plugin;
+extern struct uwsgi_plugin pypy3_plugin;
 %s
 ''' % ('\n'.join(uwsgi_defines), uwsgi_dot_h, hooks)
 
@@ -286,7 +298,7 @@
 
 # fix argv if needed
 if len(sys.argv) == 0:
-    sys.argv.insert(0, ffi.string(lib.uwsgi_binary_path()))
+    sys.argv.insert(0, n(ffi.string(lib.uwsgi_binary_path())))
 
 
 @ffi.callback("void(char *)")
@@ -305,7 +317,7 @@
     load a wsgi module
     """
     global wsgi_application
-    m = ffi.string(module)
+    m = n(ffi.string(module))
     c = 'application'
     if ':' in m:
         m, c = m.split(':')
@@ -322,7 +334,7 @@
     load a mod_wsgi compliant .wsgi file
     """
     global wsgi_application
-    w = ffi.string(filename)
+    w = n(ffi.string(filename))
     c = 'application'
     mod = imp.load_source('uwsgi_file_wsgi', w)
     wsgi_application = getattr(mod, c)
@@ -334,7 +346,7 @@
     load a .ini paste app
     """
     global wsgi_application
-    c = ffi.string(config)
+    c = n(ffi.string(config))
     if c.startswith('config:'):
         c = c[7:]
     if c[0] != '/':
@@ -363,7 +375,7 @@
     """
     add an item to the pythonpath
     """
-    path = ffi.string(item)
+    path = n(ffi.string(item))
     sys.path.append(path)
     print("added %s to pythonpath" % path)
 
@@ -470,15 +482,17 @@
     def start_response(status, headers, exc_info=None):
         if exc_info:
             traceback.print_exception(*exc_info)
+        status = status.encode("latin1")            
         lib.uwsgi_response_prepare_headers(wsgi_req, ffi.new("char[]", status), len(status))
         for hh in headers:
+            hh = (hh[0].encode("latin1"), hh[1].encode("latin1"))
             lib.uwsgi_response_add_header(wsgi_req, ffi.new("char[]", hh[0]), len(hh[0]), ffi.new("char[]", hh[1]), len(hh[1]))
         return writer
 
     environ = {}
     iov = wsgi_req.hvec
     for i in range(0, wsgi_req.var_cnt, 2):
-        environ[ffi.string(ffi.cast("char*", iov[i].iov_base), iov[i].iov_len)] = ffi.string(ffi.cast("char*", iov[i+1].iov_base), iov[i+1].iov_len)
+        environ[ffi.string(ffi.cast("char*", iov[i].iov_base), iov[i].iov_len).decode("latin1")] = ffi.string(ffi.cast("char*", iov[i+1].iov_base), iov[i+1].iov_len).decode("latin1")
 
     environ['wsgi.version'] = (1, 0)
     scheme = 'http'
@@ -537,7 +551,7 @@
 def uwsgi_pypy_uwsgi_register_signal(signum, kind, handler):
     cb = ffi.callback('void(int)', handler)
     uwsgi_gc.append(cb)
-    if lib.uwsgi_register_signal(signum, ffi.new("char[]", kind), cb, lib.pypy_plugin.modifier1) < 0:
+    if lib.uwsgi_register_signal(signum, ffi.new("char[]", kind), cb, lib.pypy3_plugin.modifier1) < 0:
         raise Exception("unable to register signal %d" % signum)
 uwsgi.register_signal = uwsgi_pypy_uwsgi_register_signal
 
@@ -562,7 +576,7 @@
     rpc_func = uwsgi_pypy_RPC(func)
     cb = ffi.callback("int(int, char*[], int[], char**)", rpc_func)
     uwsgi_gc.append(cb)
-    if lib.uwsgi_register_rpc(ffi.new("char[]", name), ffi.addressof(lib.pypy_plugin), argc, cb) < 0:
+    if lib.uwsgi_register_rpc(ffi.new("char[]", name), ffi.addressof(lib.pypy3_plugin), argc, cb) < 0:
         raise Exception("unable to register rpc func %s" % name)
 uwsgi.register_rpc = uwsgi_pypy_uwsgi_register_rpc
 
@@ -598,8 +612,8 @@
 
 def uwsgi_pypy_call(func, *args):
     node = None
-    if '@' in func:
-        (func, node) = func.split('@')
+    if b'@' in func:
+        (func, node) = func.split(b'@')
     return uwsgi_pypy_rpc(node, func, *args)
 uwsgi.call = uwsgi_pypy_call
 
