--- plugins/pypy/pypy_plugin.c.orig	2022-09-21 14:46:45 UTC
+++ plugins/pypy/pypy_plugin.c
@@ -42,9 +42,10 @@ void (*uwsgi_pypy_hook_paste_loader)(char *);
 void (*uwsgi_pypy_hook_pythonpath)(char *);
 void (*uwsgi_pypy_hook_request)(void *, int);
 void (*uwsgi_pypy_post_fork_hook)(void);
+void (*uwsgi_pypy_hook_atexit)(void);
 
 extern struct uwsgi_server uwsgi;
-struct uwsgi_plugin pypy_plugin;
+struct uwsgi_plugin pypy3_plugin;
 
 static int uwsgi_pypy_init() {
 
@@ -58,7 +59,7 @@ static int uwsgi_pypy_init() {
 	}
 
 	if (dlsym(RTLD_DEFAULT, "rpython_startup_code")) {
-		uwsgi_log("PyPy runtime detected, skipping libpypy-c loading\n");
+		uwsgi_log("PyPy runtime detected, skipping libpypy3-c loading\n");
 		goto ready;
 	}
 	else if (upypy.lib) {
@@ -68,26 +69,26 @@ static int uwsgi_pypy_init() {
 		if (upypy.home) {
 			// first try with /bin way:
 #ifdef __CYGWIN__
-                        char *libpath = uwsgi_concat2(upypy.home, "/bin/libpypy-c.dll");
+			char *libpath = uwsgi_concat2(upypy.home, "/bin/libpypy3-c.so");
 #elif defined(__APPLE__)
-                        char *libpath = uwsgi_concat2(upypy.home, "/bin/libpypy-c.dylib");
+			char *libpath = uwsgi_concat2(upypy.home, "/bin/libpypy3-c.so");
 #else
-                        char *libpath = uwsgi_concat2(upypy.home, "/bin/libpypy-c.so");
+			char *libpath = uwsgi_concat2(upypy.home, "/bin/libpypy3-c.so");
 #endif
 			if (uwsgi_file_exists(libpath)) {
-                                upypy.handler = dlopen(libpath, RTLD_NOW | RTLD_GLOBAL);
-                        }
-                        free(libpath);
+				upypy.handler = dlopen(libpath, RTLD_NOW | RTLD_GLOBAL);
+			}
+			free(libpath);
 
 			// fallback to old-style way
 			if (!upypy.handler) {
 			
 #ifdef __CYGWIN__
-                        	char *libpath = uwsgi_concat2(upypy.home, "/libpypy-c.dll");
+				char *libpath = uwsgi_concat2(upypy.home, "/libpypy3-c.so");
 #elif defined(__APPLE__)
-                        	char *libpath = uwsgi_concat2(upypy.home, "/libpypy-c.dylib");
+				char *libpath = uwsgi_concat2(upypy.home, "/libpypy3-c.dylib");
 #else
-                        	char *libpath = uwsgi_concat2(upypy.home, "/libpypy-c.so");
+				char *libpath = uwsgi_concat2(upypy.home, "/libpypy3-c.so");
 #endif
 				if (uwsgi_file_exists(libpath)) {
 					upypy.handler = dlopen(libpath, RTLD_NOW | RTLD_GLOBAL);
@@ -98,11 +99,11 @@ static int uwsgi_pypy_init() {
 		// fallback to standard library search path
 		if (!upypy.handler) {
 #ifdef __CYGWIN__
-			upypy.handler = dlopen("libpypy-c.dll", RTLD_NOW | RTLD_GLOBAL);
+			upypy.handler = dlopen("libpypy3-c.dll", RTLD_NOW | RTLD_GLOBAL);
 #elif defined(__APPLE__)
-			upypy.handler = dlopen("libpypy-c.dylib", RTLD_NOW | RTLD_GLOBAL);
+			upypy.handler = dlopen("libpypy3-c.dylib", RTLD_NOW | RTLD_GLOBAL);
 #else
-			upypy.handler = dlopen("libpypy-c.so", RTLD_NOW | RTLD_GLOBAL);
+			upypy.handler = dlopen("libpypy3-c.so", RTLD_NOW | RTLD_GLOBAL);
 #endif
 		}
 	}
@@ -126,7 +127,7 @@ static int uwsgi_pypy_init() {
 
 	u_pypy_init_threads = dlsym(upypy.handler, "pypy_init_threads");
         if (!u_pypy_init_threads) {
-                uwsgi_log("!!! WARNING your libpypy-c does not export pypy_init_threads, multithreading will not work !!!\n");
+                uwsgi_log("!!! WARNING your libpypy3-c does not export pypy_init_threads, multithreading will not work !!!\n");
         }
 	
 	u_rpython_startup_code();
@@ -161,7 +162,7 @@ ready:
 
 	u_pypy_thread_attach = dlsym(upypy.handler, "pypy_thread_attach");
         if (!u_pypy_thread_attach) {
-                uwsgi_log("!!! WARNING your libpypy-c does not export pypy_thread_attach, multithreading will not work !!!\n");
+                uwsgi_log("!!! WARNING your libpypy3-c does not export pypy_thread_attach, multithreading will not work !!!\n");
         }
 
 	if (upypy.setup) {
@@ -266,13 +267,17 @@ static void uwsgi_pypy_init_apps() {
 	}
 }
 
-/*
+
 static void uwsgi_pypy_atexit() {
-	if (pypy_debug_file)
-		fflush(pypy_debug_file);
+	/* NOTE: this function is NOT called when "skip-atexit = true" is configured */
+	if (!uwsgi_pypy_hook_atexit) {
+		uwsgi_log("!!! Your pypy setup does not define a uwsgi_pypy_atexit !!!\n");	       
+		return;
+	}	     
+	uwsgi_pypy_hook_atexit();
 }
-*/
 
+
 static void uwsgi_opt_pypy_ini_paste(char *opt, char *value, void *foobar) {
         uwsgi_opt_load_ini(opt, value, NULL);
         upypy.paste = value;
@@ -372,8 +377,8 @@ static int uwsgi_pypy_mule(char *opt) {
 }
 
 
-struct uwsgi_plugin pypy_plugin = {
-	.name = "pypy",
+struct uwsgi_plugin pypy3_plugin = {
+	.name = "pypy3",
 	.modifier1 = 0,
 	.on_load = uwsgi_pypy_onload,
 	.init = uwsgi_pypy_init,
@@ -388,4 +393,6 @@ struct uwsgi_plugin pypy_plugin = {
 	.rpc = uwsgi_pypy_rpc,
 	.post_fork = uwsgi_pypy_post_fork,
 	.mule = uwsgi_pypy_mule,
+
+	.atexit = uwsgi_pypy_atexit,
 };
