--- plugins/pypy/pypy_setup.py.orig	2020-07-09 07:54:09.000000000 +0200
+++ plugins/pypy/pypy_setup.py	2020-08-05 02:24:53.865927000 +0200
@@ -31,8 +31,15 @@
 extern void (*uwsgi_pypy_hook_pythonpath)(char *);
 extern void (*uwsgi_pypy_hook_request)(struct wsgi_request *);
 extern void (*uwsgi_pypy_post_fork_hook)(void);
+extern void (*uwsgi_pypy_hook_atexit)(void);
 '''
 
+
+# Convert a byte string to a native string using the default encoding
+def n(b):
+    return b.decode()
+
+
 # here we load CFLAGS and uwsgi.h from the binary
 defines0 = '''
 char *uwsgi_get_cflags();
@@ -46,7 +53,7 @@
 # basically it build a list of #define from binary CFLAGS
 uwsgi_cdef = []
 uwsgi_defines = []
-uwsgi_cflags = ffi.string(lib0.uwsgi_get_cflags()).split()
+uwsgi_cflags = n(ffi.string(lib0.uwsgi_get_cflags())).split()
 for cflag in uwsgi_cflags:
     if cflag.startswith('-D'):
         line = cflag[2:]
@@ -57,8 +64,14 @@
         else:
             uwsgi_cdef.append('#define %s ...' % line)
             uwsgi_defines.append('#define %s 1' % line)
-uwsgi_dot_h = ffi.string(lib0.uwsgi_get_dot_h())
+uwsgi_dot_h = n(ffi.string(lib0.uwsgi_get_dot_h()))
 
+#
+# Replace #include <pcre.h> on FreeBSD because it is found on a non-standard
+# location for cffi.
+#
+uwsgi_dot_h = uwsgi_dot_h.replace('#include <pcre.h>', '#include "/usr/local/include/pcre.h"')
+
 # uwsgi definitions
 cdefines = '''
 %s
@@ -110,6 +123,8 @@
         uint64_t running_time;
         uint64_t avg_response_time;
         uint64_t tx;
+
+        int hijacked;
         ...;
 };
 
@@ -164,11 +179,14 @@
         struct wsgi_request *wsgi_req;
 
         struct uwsgi_plugin *p[];
+
+        int skip_atexit_teardown;
+
         ...;
 };
 struct uwsgi_server uwsgi;
 
-struct uwsgi_plugin pypy_plugin;
+struct uwsgi_plugin pypy3_plugin;
 
 const char *uwsgi_pypy_version;
 
@@ -269,7 +287,7 @@
 %s
 
 extern struct uwsgi_server uwsgi;
-extern struct uwsgi_plugin pypy_plugin;
+extern struct uwsgi_plugin pypy3_plugin;
 %s
 ''' % ('\n'.join(uwsgi_defines), uwsgi_dot_h, hooks)
 
@@ -286,7 +304,7 @@
 
 # fix argv if needed
 if len(sys.argv) == 0:
-    sys.argv.insert(0, ffi.string(lib.uwsgi_binary_path()))
+    sys.argv.insert(0, n(ffi.string(lib.uwsgi_binary_path())))
 
 
 @ffi.callback("void(char *)")
@@ -305,7 +323,7 @@
     load a wsgi module
     """
     global wsgi_application
-    m = ffi.string(module)
+    m = n(ffi.string(module))
     c = 'application'
     if ':' in m:
         m, c = m.split(':')
@@ -322,7 +340,7 @@
     load a mod_wsgi compliant .wsgi file
     """
     global wsgi_application
-    w = ffi.string(filename)
+    w = n(ffi.string(filename))
     c = 'application'
     mod = imp.load_source('uwsgi_file_wsgi', w)
     wsgi_application = getattr(mod, c)
@@ -334,7 +352,7 @@
     load a .ini paste app
     """
     global wsgi_application
-    c = ffi.string(config)
+    c = n(ffi.string(config))
     if c.startswith('config:'):
         c = c[7:]
     if c[0] != '/':
@@ -358,12 +376,47 @@
         uwsgi.post_fork_hook()
 
 
+@ffi.callback("void()")
+def uwsgi_pypy_atexit():
+    """
+    .atexit handler implementation
+
+    Modelled after python_plugin.c
+    """
+    mywid = lib.uwsgi.mywid
+    if mywid > 0:
+        # if hijacked do not run atexit hooks
+        if lib.uwsgi.workers[mywid].hijacked:
+            return
+        # if busy do not run atexit hooks
+        if lib.uwsgi_worker_is_busy(mywid):
+            return
+        # managing atexit in async mode is a real pain...skip it for now
+        if lib.uwsgi.async > 0:
+            return
+
+    import uwsgi
+    uahandler = getattr(uwsgi, "atexit", None)
+    if callable(uahandler):
+        uahandler()
+
+    if lib.uwsgi.skip_atexit_teardown:
+        return
+
+    import atexit
+    aefn = getattr(atexit, "_run_exitfuncs", None)
+    if callable(aefn):
+        aefn()
+    else:
+        print("!!! atexit._run_exitfuncs() not found !!!")
+
+
 @ffi.callback("void(char *)")
 def uwsgi_pypy_pythonpath(item):
     """
     add an item to the pythonpath
     """
-    path = ffi.string(item)
+    path = n(ffi.string(item))
     sys.path.append(path)
     print("added %s to pythonpath" % path)
 
@@ -470,15 +523,17 @@
     def start_response(status, headers, exc_info=None):
         if exc_info:
             traceback.print_exception(*exc_info)
+        status = status.encode("latin1")
         lib.uwsgi_response_prepare_headers(wsgi_req, ffi.new("char[]", status), len(status))
         for hh in headers:
+            hh = (hh[0].encode("latin1"), hh[1].encode("latin1"))
             lib.uwsgi_response_add_header(wsgi_req, ffi.new("char[]", hh[0]), len(hh[0]), ffi.new("char[]", hh[1]), len(hh[1]))
         return writer
 
     environ = {}
     iov = wsgi_req.hvec
     for i in range(0, wsgi_req.var_cnt, 2):
-        environ[ffi.string(ffi.cast("char*", iov[i].iov_base), iov[i].iov_len)] = ffi.string(ffi.cast("char*", iov[i+1].iov_base), iov[i+1].iov_len)
+        environ[ffi.string(ffi.cast("char*", iov[i].iov_base), iov[i].iov_len).decode("latin1")] = ffi.string(ffi.cast("char*", iov[i+1].iov_base), iov[i+1].iov_len).decode("latin1")
 
     environ['wsgi.version'] = (1, 0)
     scheme = 'http'
@@ -523,6 +578,7 @@
 lib.uwsgi_pypy_hook_pythonpath = uwsgi_pypy_pythonpath
 lib.uwsgi_pypy_hook_request = uwsgi_pypy_wsgi_handler
 lib.uwsgi_pypy_post_fork_hook = uwsgi_pypy_post_fork_hook
+lib.uwsgi_pypy_hook_atexit = uwsgi_pypy_atexit
 
 """
 Here we define the "uwsgi" virtual module
@@ -537,7 +593,7 @@
 def uwsgi_pypy_uwsgi_register_signal(signum, kind, handler):
     cb = ffi.callback('void(int)', handler)
     uwsgi_gc.append(cb)
-    if lib.uwsgi_register_signal(signum, ffi.new("char[]", kind), cb, lib.pypy_plugin.modifier1) < 0:
+    if lib.uwsgi_register_signal(signum, ffi.new("char[]", kind), cb, lib.pypy3_plugin.modifier1) < 0:
         raise Exception("unable to register signal %d" % signum)
 uwsgi.register_signal = uwsgi_pypy_uwsgi_register_signal
 
@@ -562,7 +618,7 @@
     rpc_func = uwsgi_pypy_RPC(func)
     cb = ffi.callback("int(int, char*[], int[], char**)", rpc_func)
     uwsgi_gc.append(cb)
-    if lib.uwsgi_register_rpc(ffi.new("char[]", name), ffi.addressof(lib.pypy_plugin), argc, cb) < 0:
+    if lib.uwsgi_register_rpc(ffi.new("char[]", name), ffi.addressof(lib.pypy3_plugin), argc, cb) < 0:
         raise Exception("unable to register rpc func %s" % name)
 uwsgi.register_rpc = uwsgi_pypy_uwsgi_register_rpc
 
@@ -598,8 +654,8 @@
 
 def uwsgi_pypy_call(func, *args):
     node = None
-    if '@' in func:
-        (func, node) = func.split('@')
+    if b'@' in func:
+        (func, node) = func.split(b'@')
     return uwsgi_pypy_rpc(node, func, *args)
 uwsgi.call = uwsgi_pypy_call
 
