#!/bin/sh

set -e
set -x
set -u

RELEASE="13.2"
NEW_VER="p5"
BASE_RO="dpool/jail/ttmpl/base-ro/${RELEASE}-RELEASE"
SKEL_RW="dpool/jail/ttmpl/skel-rw/${RELEASE}-RELEASE"

MOUNTPOINT="/var/tmp/${RELEASE}"

ftjail mount-tmpl -P "$BASE_RO" "$SKEL_RW" "$MOUNTPOINT"

freebsd-update -b "$MOUNTPOINT" --currently-running "${RELEASE}-RELEASE" fetch 
freebsd-update -b "$MOUNTPOINT" install

ftjail snapshot-tmpl "$BASE_RO" "$SKEL_RW" "$NEW_VER"

ftjail build-etcupdate-current-tmpl "$MOUNTPOINT" "/jail/RELEASE/etcupdate-current-${RELEASE}@${NEW_VER}.tbz"

ftjail umount-tmpl -P "$BASE_RO" "$SKEL_RW"
