Basic tests of farray.sh's farray_XXX functions

Shell is /bin/sh.


Setup
=====

  $ set -u
  $ . "${TESTDIR}/testsetup.sh"
  $ _p_datadir="${TESTDIR}/../share/local-bsdtools"
  $ . "${_p_datadir}/farray.sh"


Basic Creation and Destruction
==============================

Create an empty array

  $ farray_create EMPTY
  $ farray_print_length EMPTY
  0 (no-eol)
  $ farray_length _var EMPTY
  $ test ${_var} -eq 0
  $ farray_debug EMPTY
  DEBUG: array `EMPTY' has length 0
  $ farray_destroy EMPTY
  $ check_no_array_artifacts

Create and destroy an array

  $ farray_create TEST 0 1 2 '3  4   5' $'" 678" \\\'90 '
  $ farray_print_length TEST
  5 (no-eol)
  $ farray_length _var TEST
  $ test ${_var} -eq 5
  $ farray_debug TEST
  DEBUG: array `TEST' has length 5
  DEBUG:   its contents:
  DEBUG:     1: `0'
  DEBUG:     2: `1'
  DEBUG:     3: `2'
  DEBUG:     4: `3  4   5'
  DEBUG:     5: `" 678" \'90 '
  $ farray_destroy TEST
  $ check_no_array_artifacts

Create, clear and destroy an array

  $ farray_create TEST 0 1 2 '3  4   5' $'" 678" \\\'90 '
  $ farray_print_length TEST
  5 (no-eol)
  $ farray_length _var TEST
  $ test ${_var} -eq 5
  $ farray_debug TEST
  DEBUG: array `TEST' has length 5
  DEBUG:   its contents:
  DEBUG:     1: `0'
  DEBUG:     2: `1'
  DEBUG:     3: `2'
  DEBUG:     4: `3  4   5'
  DEBUG:     5: `" 678" \'90 '
  $ farray_clear TEST
  $ farray_print_length TEST
  0 (no-eol)
  $ farray_length _var TEST
  $ test ${_var} -eq 0
  $ farray_destroy TEST
  $ check_no_array_artifacts

Duplicate destruction

  $ farray_create TEST 1 2 3
  $ farray_destroy TEST
  $ farray_destroy TEST
  ERROR: farray `TEST' does not exist: token empty
  [1]
  $ check_no_array_artifacts


Equality
========

Equality (empty)

  $ farray_create TEST1
  $ farray_create TEST2
  $ farray_are_equal TEST1 TEST2
  $ farray_destroy TEST1
  $ farray_destroy TEST2
  $ check_no_array_artifacts

Equality (non-empty)

  $ farray_create TEST1 0 1 2 '3  4   5' $'" 678" \\\'90 '
  $ farray_create TEST2 0 1 2 '3  4   5' $'" 678" \\\'90 '
  $ farray_are_equal TEST1 TEST2
  $ farray_destroy TEST1
  $ farray_destroy TEST2
  $ check_no_array_artifacts

In-Equality (non-empty, same length)

  $ farray_create TEST1 0 1 2 '3  4   5' $'" 678" \\\'90 '
  $ farray_create TEST2 0 1 2 '3  4   5' $'" 678" \\\'90'
  $ farray_are_equal TEST1 TEST2
  [1]
  $ farray_destroy TEST1
  $ farray_destroy TEST2
  $ check_no_array_artifacts

In-Equality (non-empty, different length)

  $ farray_create TEST1 0 1 2 '3  4   5' $'" 678" \\\'90 '
  $ farray_create TEST2   1 2 '3  4   5' $'" 678" \\\'90 '
  $ farray_are_equal TEST1 TEST2
  [1]
  $ farray_destroy TEST1
  $ farray_destroy TEST2
  $ check_no_array_artifacts


Get
===

  $ farray_create TEST 0 1 2 '3  4   5' $'" 678" \\\'910 ' 11

  $ farray_get _var TEST 1
  $ echo $_var
  0
  $ farray_tryget _var TEST 1
  $ echo $_var
  0
  $ farray_get _var TEST -5
  $ echo $_var
  0
  $ farray_tryget _var TEST -5
  $ echo $_var
  0
  $ farray_get _var TEST 6
  $ echo $_var
  11
  $ farray_tryget _var TEST 6
  $ echo $_var
  11
  $ farray_get _var TEST 0
  $ echo $_var
  11
  $ farray_tryget _var TEST 0
  $ echo $_var
  11
  $ farray_get _var TEST 5
  $ echo $_var
  " 678" \'910
  $ farray_tryget _var TEST 5
  $ echo $_var
  " 678" \'910
  $ farray_get _var TEST -1
  $ echo $_var
  " 678" \'910
  $ farray_tryget _var TEST -1
  $ echo $_var
  " 678" \'910

  $ farray_tryget _var TEST -6
  [1]
  $ ( farray_get _var TEST -6 )
  ERROR: array index out of bounds
  [70]
  $ farray_tryget _var TEST 7
  [1]
  $ ( farray_get _var TEST 7 )
  ERROR: array index out of bounds
  [70]

  $ farray_destroy TEST
  $ check_no_array_artifacts


Splicing
========

Replace complete array

  $ farray_create DELETED
  $ farray_create INSERTED  ' I 1 ' ' I 2 ' ' I 3 '
  $ farray_create TEST ' v 1 ' ' v 2 ' ' v 3 ' ' v 4 ' ' v 5 ' ' v 6 ' ' v 7 ' ' v 8 '  ' v 9 '
  $ farray_splice DELETED TEST 1 ""  INSERTED
  $ farray_debug DELETED
  DEBUG: array `DELETED' has length 9
  DEBUG:   its contents:
  DEBUG:     1: ` v 1 '
  DEBUG:     2: ` v 2 '
  DEBUG:     3: ` v 3 '
  DEBUG:     4: ` v 4 '
  DEBUG:     5: ` v 5 '
  DEBUG:     6: ` v 6 '
  DEBUG:     7: ` v 7 '
  DEBUG:     8: ` v 8 '
  DEBUG:     9: ` v 9 '
  $ farray_debug TEST
  DEBUG: array `TEST' has length 3
  DEBUG:   its contents:
  DEBUG:     1: ` I 1 '
  DEBUG:     2: ` I 2 '
  DEBUG:     3: ` I 3 '
  $ farray_destroy DELETED
  $ farray_destroy INSERTED
  $ farray_destroy TEST
  $ check_no_array_artifacts

Insert at the beginning (prepend)

  $ farray_create DELETED
  $ farray_create INSERTED  ' I 1 ' ' I 2 ' ' I 3 '
  $ farray_create TEST ' v 1 ' ' v 2 ' ' v 3 ' ' v 4 ' ' v 5 ' ' v 6 ' ' v 7 ' ' v 8 '  ' v 9 '
  $ farray_splice DELETED TEST 1 0  INSERTED
  $ farray_debug DELETED
  DEBUG: array `DELETED' has length 0
  $ farray_debug TEST
  DEBUG: array `TEST' has length 12
  DEBUG:   its contents:
  DEBUG:     1: ` I 1 '
  DEBUG:     2: ` I 2 '
  DEBUG:     3: ` I 3 '
  DEBUG:     4: ` v 1 '
  DEBUG:     5: ` v 2 '
  DEBUG:     6: ` v 3 '
  DEBUG:     7: ` v 4 '
  DEBUG:     8: ` v 5 '
  DEBUG:     9: ` v 6 '
  DEBUG:     10: ` v 7 '
  DEBUG:     11: ` v 8 '
  DEBUG:     12: ` v 9 '
  $ farray_destroy DELETED
  $ farray_destroy INSERTED
  $ farray_destroy TEST
  $ check_no_array_artifacts

Insert at the end (extend)

  $ farray_create DELETED
  $ farray_create INSERTED  ' I 1 ' ' I 2 ' ' I 3 '
  $ farray_create TEST ' v 1 ' ' v 2 ' ' v 3 ' ' v 4 ' ' v 5 ' ' v 6 ' ' v 7 ' ' v 8 '  ' v 9 '
  $ farray_splice DELETED TEST "" 0  INSERTED
  $ farray_debug DELETED
  DEBUG: array `DELETED' has length 0
  $ farray_debug TEST
  DEBUG: array `TEST' has length 12
  DEBUG:   its contents:
  DEBUG:     1: ` v 1 '
  DEBUG:     2: ` v 2 '
  DEBUG:     3: ` v 3 '
  DEBUG:     4: ` v 4 '
  DEBUG:     5: ` v 5 '
  DEBUG:     6: ` v 6 '
  DEBUG:     7: ` v 7 '
  DEBUG:     8: ` v 8 '
  DEBUG:     9: ` v 9 '
  DEBUG:     10: ` I 1 '
  DEBUG:     11: ` I 2 '
  DEBUG:     12: ` I 3 '
  $ farray_destroy DELETED
  $ farray_destroy INSERTED
  $ farray_destroy TEST
  $ check_no_array_artifacts

Insert in the middle

  $ farray_create DELETED
  $ farray_create INSERTED  ' I 1 ' ' I 2 ' ' I 3 '
  $ farray_create TEST ' v 1 ' ' v 2 ' ' v 3 ' ' v 4 ' ' v 5 ' ' v 6 ' ' v 7 ' ' v 8 '  ' v 9 '
  $ farray_splice DELETED TEST 4 0  INSERTED
  $ farray_debug DELETED
  DEBUG: array `DELETED' has length 0
  $ farray_debug TEST
  DEBUG: array `TEST' has length 12
  DEBUG:   its contents:
  DEBUG:     1: ` v 1 '
  DEBUG:     2: ` v 2 '
  DEBUG:     3: ` v 3 '
  DEBUG:     4: ` I 1 '
  DEBUG:     5: ` I 2 '
  DEBUG:     6: ` I 3 '
  DEBUG:     7: ` v 4 '
  DEBUG:     8: ` v 5 '
  DEBUG:     9: ` v 6 '
  DEBUG:     10: ` v 7 '
  DEBUG:     11: ` v 8 '
  DEBUG:     12: ` v 9 '
  $ farray_destroy DELETED
  $ farray_destroy INSERTED
  $ farray_destroy TEST
  $ check_no_array_artifacts

"Clear" (empty inserted)

  $ farray_create DELETED
  $ farray_create INSERTED
  $ farray_create TEST ' v 1 ' ' v 2 ' ' v 3 ' ' v 4 ' ' v 5 ' ' v 6 ' ' v 7 ' ' v 8 '  ' v 9 '
  $ farray_splice DELETED TEST 1 "" INSERTED
  $ farray_debug DELETED
  DEBUG: array `DELETED' has length 9
  DEBUG:   its contents:
  DEBUG:     1: ` v 1 '
  DEBUG:     2: ` v 2 '
  DEBUG:     3: ` v 3 '
  DEBUG:     4: ` v 4 '
  DEBUG:     5: ` v 5 '
  DEBUG:     6: ` v 6 '
  DEBUG:     7: ` v 7 '
  DEBUG:     8: ` v 8 '
  DEBUG:     9: ` v 9 '
  $ farray_debug TEST
  DEBUG: array `TEST' has length 0
  $ farray_destroy DELETED
  $ farray_destroy INSERTED
  $ farray_destroy TEST
  $ check_no_array_artifacts

"Clear" (no inserted)

  $ farray_create DELETED
  $ farray_create TEST ' v 1 ' ' v 2 ' ' v 3 ' ' v 4 ' ' v 5 ' ' v 6 ' ' v 7 ' ' v 8 '  ' v 9 '
  $ farray_splice DELETED TEST 1 ""
  $ farray_debug DELETED
  DEBUG: array `DELETED' has length 9
  DEBUG:   its contents:
  DEBUG:     1: ` v 1 '
  DEBUG:     2: ` v 2 '
  DEBUG:     3: ` v 3 '
  DEBUG:     4: ` v 4 '
  DEBUG:     5: ` v 5 '
  DEBUG:     6: ` v 6 '
  DEBUG:     7: ` v 7 '
  DEBUG:     8: ` v 8 '
  DEBUG:     9: ` v 9 '
  $ farray_debug TEST
  DEBUG: array `TEST' has length 0
  $ farray_destroy DELETED
  $ farray_destroy TEST
  $ check_no_array_artifacts

Cut out some part in the middle

  $ farray_create DELETED
  $ farray_create TEST ' v 1 ' ' v 2 ' ' v 3 ' ' v 4 ' ' v 5 ' ' v 6 ' ' v 7 ' ' v 8 '  ' v 9 '
  $ farray_splice DELETED TEST 2 5
  $ farray_debug DELETED
  DEBUG: array `DELETED' has length 5
  DEBUG:   its contents:
  DEBUG:     1: ` v 2 '
  DEBUG:     2: ` v 3 '
  DEBUG:     3: ` v 4 '
  DEBUG:     4: ` v 5 '
  DEBUG:     5: ` v 6 '
  $ farray_debug TEST
  DEBUG: array `TEST' has length 4
  DEBUG:   its contents:
  DEBUG:     1: ` v 1 '
  DEBUG:     2: ` v 7 '
  DEBUG:     3: ` v 8 '
  DEBUG:     4: ` v 9 '
  $ farray_destroy DELETED
  $ farray_destroy TEST
  $ check_no_array_artifacts

Cut out some part from the beginning

  $ farray_create DELETED
  $ farray_create TEST ' v 1 ' ' v 2 ' ' v 3 ' ' v 4 ' ' v 5 ' ' v 6 ' ' v 7 ' ' v 8 '  ' v 9 '
  $ farray_splice DELETED TEST 1 6
  $ farray_debug DELETED
  DEBUG: array `DELETED' has length 6
  DEBUG:   its contents:
  DEBUG:     1: ` v 1 '
  DEBUG:     2: ` v 2 '
  DEBUG:     3: ` v 3 '
  DEBUG:     4: ` v 4 '
  DEBUG:     5: ` v 5 '
  DEBUG:     6: ` v 6 '
  $ farray_debug TEST
  DEBUG: array `TEST' has length 3
  DEBUG:   its contents:
  DEBUG:     1: ` v 7 '
  DEBUG:     2: ` v 8 '
  DEBUG:     3: ` v 9 '
  $ farray_destroy DELETED
  $ farray_destroy TEST
  $ check_no_array_artifacts

Cut out some part at the end (1)

  $ farray_create DELETED
  $ farray_create TEST ' v 1 ' ' v 2 ' ' v 3 ' ' v 4 ' ' v 5 ' ' v 6 ' ' v 7 ' ' v 8 '  ' v 9 '
  $ farray_splice DELETED TEST 0 1
  $ farray_debug DELETED
  DEBUG: array `DELETED' has length 1
  DEBUG:   its contents:
  DEBUG:     1: ` v 9 '
  $ farray_debug TEST
  DEBUG: array `TEST' has length 8
  DEBUG:   its contents:
  DEBUG:     1: ` v 1 '
  DEBUG:     2: ` v 2 '
  DEBUG:     3: ` v 3 '
  DEBUG:     4: ` v 4 '
  DEBUG:     5: ` v 5 '
  DEBUG:     6: ` v 6 '
  DEBUG:     7: ` v 7 '
  DEBUG:     8: ` v 8 '
  $ farray_destroy DELETED
  $ farray_destroy TEST
  $ check_no_array_artifacts

Cut out some part at the end (1)

  $ farray_create DELETED
  $ farray_create TEST ' v 1 ' ' v 2 ' ' v 3 ' ' v 4 ' ' v 5 ' ' v 6 ' ' v 7 ' ' v 8 '  ' v 9 '
  $ farray_splice DELETED TEST -1 ""
  $ farray_debug DELETED
  DEBUG: array `DELETED' has length 2
  DEBUG:   its contents:
  DEBUG:     1: ` v 8 '
  DEBUG:     2: ` v 9 '
  $ farray_debug TEST
  DEBUG: array `TEST' has length 7
  DEBUG:   its contents:
  DEBUG:     1: ` v 1 '
  DEBUG:     2: ` v 2 '
  DEBUG:     3: ` v 3 '
  DEBUG:     4: ` v 4 '
  DEBUG:     5: ` v 5 '
  DEBUG:     6: ` v 6 '
  DEBUG:     7: ` v 7 '
  $ farray_destroy DELETED
  $ farray_destroy TEST
  $ check_no_array_artifacts

Splice at the beginning (shrink)

  $ farray_create DELETED
  $ farray_create INSERTED  ' I 1 ' ' I 2 ' ' I 3 '
  $ farray_create TEST ' v 1 ' ' v 2 ' ' v 3 ' ' v 4 ' ' v 5 ' ' v 6 ' ' v 7 ' ' v 8 '  ' v 9 '
  $ farray_splice DELETED TEST 1 4  INSERTED
  $ farray_debug DELETED
  DEBUG: array `DELETED' has length 4
  DEBUG:   its contents:
  DEBUG:     1: ` v 1 '
  DEBUG:     2: ` v 2 '
  DEBUG:     3: ` v 3 '
  DEBUG:     4: ` v 4 '
  $ farray_debug TEST
  DEBUG: array `TEST' has length 8
  DEBUG:   its contents:
  DEBUG:     1: ` I 1 '
  DEBUG:     2: ` I 2 '
  DEBUG:     3: ` I 3 '
  DEBUG:     4: ` v 5 '
  DEBUG:     5: ` v 6 '
  DEBUG:     6: ` v 7 '
  DEBUG:     7: ` v 8 '
  DEBUG:     8: ` v 9 '
  $ farray_destroy DELETED
  $ farray_destroy INSERTED
  $ farray_destroy TEST
  $ check_no_array_artifacts

Splice at the end (shrink)

  $ farray_create DELETED
  $ farray_create INSERTED  ' I 1 ' ' I 2 ' ' I 3 '
  $ farray_create TEST ' v 1 ' ' v 2 ' ' v 3 ' ' v 4 ' ' v 5 ' ' v 6 ' ' v 7 ' ' v 8 '  ' v 9 '
  $ farray_splice DELETED TEST -3 4  INSERTED
  $ farray_debug DELETED
  DEBUG: array `DELETED' has length 4
  DEBUG:   its contents:
  DEBUG:     1: ` v 6 '
  DEBUG:     2: ` v 7 '
  DEBUG:     3: ` v 8 '
  DEBUG:     4: ` v 9 '
  $ farray_debug TEST
  DEBUG: array `TEST' has length 8
  DEBUG:   its contents:
  DEBUG:     1: ` v 1 '
  DEBUG:     2: ` v 2 '
  DEBUG:     3: ` v 3 '
  DEBUG:     4: ` v 4 '
  DEBUG:     5: ` v 5 '
  DEBUG:     6: ` I 1 '
  DEBUG:     7: ` I 2 '
  DEBUG:     8: ` I 3 '
  $ farray_destroy DELETED
  $ farray_destroy INSERTED
  $ farray_destroy TEST
  $ check_no_array_artifacts

Splice in the middle (shrink)

  $ farray_create DELETED
  $ farray_create INSERTED  ' I 1 ' ' I 2 ' ' I 3 '
  $ farray_create TEST ' v 1 ' ' v 2 ' ' v 3 ' ' v 4 ' ' v 5 ' ' v 6 ' ' v 7 ' ' v 8 '  ' v 9 '
  $ farray_splice DELETED TEST 3 4  INSERTED
  $ farray_debug DELETED
  DEBUG: array `DELETED' has length 4
  DEBUG:   its contents:
  DEBUG:     1: ` v 3 '
  DEBUG:     2: ` v 4 '
  DEBUG:     3: ` v 5 '
  DEBUG:     4: ` v 6 '
  $ farray_debug TEST
  DEBUG: array `TEST' has length 8
  DEBUG:   its contents:
  DEBUG:     1: ` v 1 '
  DEBUG:     2: ` v 2 '
  DEBUG:     3: ` I 1 '
  DEBUG:     4: ` I 2 '
  DEBUG:     5: ` I 3 '
  DEBUG:     6: ` v 7 '
  DEBUG:     7: ` v 8 '
  DEBUG:     8: ` v 9 '
  $ farray_destroy DELETED
  $ farray_destroy INSERTED
  $ farray_destroy TEST
  $ check_no_array_artifacts

Splice at the beginning (grow)

  $ farray_create DELETED
  $ farray_create INSERTED  ' I 1 ' ' I 2 ' ' I 3 '
  $ farray_create TEST ' v 1 ' ' v 2 ' ' v 3 ' ' v 4 ' ' v 5 ' ' v 6 ' ' v 7 ' ' v 8 '  ' v 9 '
  $ farray_splice DELETED TEST 1 2  INSERTED
  $ farray_debug DELETED
  DEBUG: array `DELETED' has length 2
  DEBUG:   its contents:
  DEBUG:     1: ` v 1 '
  DEBUG:     2: ` v 2 '
  $ farray_debug TEST
  DEBUG: array `TEST' has length 10
  DEBUG:   its contents:
  DEBUG:     1: ` I 1 '
  DEBUG:     2: ` I 2 '
  DEBUG:     3: ` I 3 '
  DEBUG:     4: ` v 3 '
  DEBUG:     5: ` v 4 '
  DEBUG:     6: ` v 5 '
  DEBUG:     7: ` v 6 '
  DEBUG:     8: ` v 7 '
  DEBUG:     9: ` v 8 '
  DEBUG:     10: ` v 9 '
  $ farray_destroy DELETED
  $ farray_destroy INSERTED
  $ farray_destroy TEST
  $ check_no_array_artifacts

Splice at the end (grow)

  $ farray_create DELETED
  $ farray_create INSERTED  ' I 1 ' ' I 2 ' ' I 3 '
  $ farray_create TEST ' v 1 ' ' v 2 ' ' v 3 ' ' v 4 ' ' v 5 ' ' v 6 ' ' v 7 ' ' v 8 '  ' v 9 '
  $ farray_splice DELETED TEST -1 2  INSERTED
  $ farray_debug DELETED
  DEBUG: array `DELETED' has length 2
  DEBUG:   its contents:
  DEBUG:     1: ` v 8 '
  DEBUG:     2: ` v 9 '
  $ farray_debug TEST
  DEBUG: array `TEST' has length 10
  DEBUG:   its contents:
  DEBUG:     1: ` v 1 '
  DEBUG:     2: ` v 2 '
  DEBUG:     3: ` v 3 '
  DEBUG:     4: ` v 4 '
  DEBUG:     5: ` v 5 '
  DEBUG:     6: ` v 6 '
  DEBUG:     7: ` v 7 '
  DEBUG:     8: ` I 1 '
  DEBUG:     9: ` I 2 '
  DEBUG:     10: ` I 3 '
  $ farray_destroy DELETED
  $ farray_destroy INSERTED
  $ farray_destroy TEST
  $ check_no_array_artifacts

Splice in the middle (grow)

  $ farray_create DELETED
  $ farray_create INSERTED  ' I 1 ' ' I 2 ' ' I 3 '
  $ farray_create TEST ' v 1 ' ' v 2 ' ' v 3 ' ' v 4 ' ' v 5 ' ' v 6 ' ' v 7 ' ' v 8 '  ' v 9 '
  $ farray_splice DELETED TEST 3 2  INSERTED
  $ farray_debug DELETED
  DEBUG: array `DELETED' has length 2
  DEBUG:   its contents:
  DEBUG:     1: ` v 3 '
  DEBUG:     2: ` v 4 '
  $ farray_debug TEST
  DEBUG: array `TEST' has length 10
  DEBUG:   its contents:
  DEBUG:     1: ` v 1 '
  DEBUG:     2: ` v 2 '
  DEBUG:     3: ` I 1 '
  DEBUG:     4: ` I 2 '
  DEBUG:     5: ` I 3 '
  DEBUG:     6: ` v 5 '
  DEBUG:     7: ` v 6 '
  DEBUG:     8: ` v 7 '
  DEBUG:     9: ` v 8 '
  DEBUG:     10: ` v 9 '
  $ farray_destroy DELETED
  $ farray_destroy INSERTED
  $ farray_destroy TEST
  $ check_no_array_artifacts

Splice at the beginning (no length change)

  $ farray_create DELETED
  $ farray_create INSERTED  ' I 1 ' ' I 2 ' ' I 3 '
  $ farray_create TEST ' v 1 ' ' v 2 ' ' v 3 ' ' v 4 ' ' v 5 ' ' v 6 ' ' v 7 ' ' v 8 '  ' v 9 '
  $ farray_splice DELETED TEST 1 3 INSERTED
  $ farray_debug DELETED
  DEBUG: array `DELETED' has length 3
  DEBUG:   its contents:
  DEBUG:     1: ` v 1 '
  DEBUG:     2: ` v 2 '
  DEBUG:     3: ` v 3 '
  $ farray_debug TEST
  DEBUG: array `TEST' has length 9
  DEBUG:   its contents:
  DEBUG:     1: ` I 1 '
  DEBUG:     2: ` I 2 '
  DEBUG:     3: ` I 3 '
  DEBUG:     4: ` v 4 '
  DEBUG:     5: ` v 5 '
  DEBUG:     6: ` v 6 '
  DEBUG:     7: ` v 7 '
  DEBUG:     8: ` v 8 '
  DEBUG:     9: ` v 9 '
  $ farray_destroy DELETED
  $ farray_destroy INSERTED
  $ farray_destroy TEST
  $ check_no_array_artifacts

Splice at the end (no length change)

  $ farray_create DELETED
  $ farray_create INSERTED  ' I 1 ' ' I 2 ' ' I 3 '
  $ farray_create TEST ' v 1 ' ' v 2 ' ' v 3 ' ' v 4 ' ' v 5 ' ' v 6 ' ' v 7 ' ' v 8 '  ' v 9 '
  $ farray_splice DELETED TEST -2 3 INSERTED
  $ farray_debug DELETED
  DEBUG: array `DELETED' has length 3
  DEBUG:   its contents:
  DEBUG:     1: ` v 7 '
  DEBUG:     2: ` v 8 '
  DEBUG:     3: ` v 9 '
  $ farray_debug TEST
  DEBUG: array `TEST' has length 9
  DEBUG:   its contents:
  DEBUG:     1: ` v 1 '
  DEBUG:     2: ` v 2 '
  DEBUG:     3: ` v 3 '
  DEBUG:     4: ` v 4 '
  DEBUG:     5: ` v 5 '
  DEBUG:     6: ` v 6 '
  DEBUG:     7: ` I 1 '
  DEBUG:     8: ` I 2 '
  DEBUG:     9: ` I 3 '
  $ farray_destroy DELETED
  $ farray_destroy INSERTED
  $ farray_destroy TEST
  $ check_no_array_artifacts

Splice in the middle (no length change)

  $ farray_create DELETED
  $ farray_create INSERTED  ' I 1 ' ' I 2 ' ' I 3 '
  $ farray_create TEST ' v 1 ' ' v 2 ' ' v 3 ' ' v 4 ' ' v 5 ' ' v 6 ' ' v 7 ' ' v 8 '  ' v 9 '
  $ farray_splice DELETED TEST 4 3 INSERTED
  $ farray_debug DELETED
  DEBUG: array `DELETED' has length 3
  DEBUG:   its contents:
  DEBUG:     1: ` v 4 '
  DEBUG:     2: ` v 5 '
  DEBUG:     3: ` v 6 '
  $ farray_debug TEST
  DEBUG: array `TEST' has length 9
  DEBUG:   its contents:
  DEBUG:     1: ` v 1 '
  DEBUG:     2: ` v 2 '
  DEBUG:     3: ` v 3 '
  DEBUG:     4: ` I 1 '
  DEBUG:     5: ` I 2 '
  DEBUG:     6: ` I 3 '
  DEBUG:     7: ` v 7 '
  DEBUG:     8: ` v 8 '
  DEBUG:     9: ` v 9 '
  $ farray_destroy DELETED
  $ farray_destroy INSERTED
  $ farray_destroy TEST
  $ check_no_array_artifacts
