Complex object tests of farray.sh

Shell is /bin/sh.


Setup
=====

  $ set -u
  $ . "${TESTDIR}/testsetup.sh"
  $ _p_datadir="${TESTDIR}/../share/local-bsdtools"
  $ . "${_p_datadir}/farray.sh"


Array
=====

  $ farray_create ARRAY1 i1 i2
  $ fobject_type ARRAY1
  array (no-eol)
  $ farray_type ARRAY1
  array (no-eol)
  $ falist_type ARRAY1
  array (no-eol)
  $ farray_create ITEM1 i11 i22
  $ farray_append ARRAY1 "$ITEM1"
  $ farray_release ITEM1
  $ falist_create LIST2 k1 v1 k2 v2 k3 v3
This also transfers ownership
  $ farray_append ARRAY1 "$LIST2"
  $ falist_release LIST2
  $ farray_debug ARRAY1
  DEBUG: array `ARRAY1' has length 4
  DEBUG:   its contents:
  DEBUG:     1: `i1'
  DEBUG:     2: `i2'
  DEBUG:     3: -->
      DEBUG: array with token `[a-f0-9]+' has length 2 (re)
      DEBUG:   its contents:
      DEBUG:     1: `i11'
      DEBUG:     2: `i22'
  DEBUG:     4: -->
      DEBUG: alist with token `[a-f0-9]+' has length 3 (re)
      DEBUG:     `k1' -> `v1'
      DEBUG:     `k2' -> `v2'
      DEBUG:     `k3' -> `v3'
  $ farray_release ARRAY1
  $ check_no_array_artifacts
  $ check_no_alist_artifacts


AList
=====

  $ falist_create LIST1 k1 v1
  $ fobject_type LIST1
  alist (no-eol)
  $ falist_type LIST1
  alist (no-eol)
  $ farray_type LIST1
  alist (no-eol)
  $ falist_create ITEM1 k11 v11 k22 v22 k33 v33 k44 v44
  $ falist_set LIST1 k2 "$ITEM1"
  $ falist_release ITEM1
  $ farray_create ARRAY2 a1 a2 a3
  $ falist_set LIST1 k3 "$ARRAY2"
  $ farray_release ARRAY2
  $ falist_debug LIST1
  DEBUG: alist `LIST1' has length 3
  DEBUG:     `k1' -> `v1'
  DEBUG:     `k2': -->
      DEBUG: alist with token `[a-f0-9]+' has length 4 (re)
      DEBUG:     `k11' -> `v11'
      DEBUG:     `k22' -> `v22'
      DEBUG:     `k33' -> `v33'
      DEBUG:     `k44' -> `v44'
  DEBUG:     `k3': -->
      DEBUG: array with token `[a-f0-9]+' has length 3 (re)
      DEBUG:   its contents:
      DEBUG:     1: `a1'
      DEBUG:     2: `a2'
      DEBUG:     3: `a3'

  $ falist_release LIST1
  $ check_no_array_artifacts
  $ check_no_alist_artifacts
