Basic tests of farray.sh's internal helper functions

Shell is /bin/sh.


Setup
=====

  $ set -u
  $ . "${TESTDIR}/testsetup.sh"
  $ _p_datadir="${TESTDIR}/../share/local-bsdtools"
  $ . "${_p_datadir}/farray.sh"


Plain Decimal Number Checks
===========================

Valid
-----

  $ _farr_is_decimal_number 0
  $ _farr_is_decimal_number 12345678901234567890
  $ _farr_is_decimal_number -12345678901234567890
  $ _farr_is_decimal_number +12345678901234567890

Octal

  $ _farr_is_decimal_number 012345678901234567890
  $ _farr_is_decimal_number -012345678901234567890
  $ _farr_is_decimal_number +12345678901234567890

Invalid
-------

  $ _farr_is_decimal_number x
  [1]
  $ _farr_is_decimal_number ''
  [1]
  $ _farr_is_decimal_number '+'
  [1]
  $ _farr_is_decimal_number '-'
  [1]
  $ _farr_is_decimal_number '0x1'
  [1]
  $ _farr_is_decimal_number *12345678901234567890
  [1]
  $ _farr_is_decimal_number 0x0123456789abcdef
  [1]
  $ _farr_is_decimal_number 0123456789abcdef
  [1]
