Tests for the behaviour of the Shell's `getopts`

Shell is /bin/sh.

Setup
=====

  $ set -u
  $ . "${TESTDIR}/testsetup.sh"


Standard
========

  $ test_standard_1 -a -b bbb1
  OPTION: a with arg: `'
  OPTION: b with arg: `bbb1'
  OPTIND: 4

The variable will be set to ``?`` after the last option when getopts returns 1:

  $ reset_getopts
  $ test_standard_1 -a -b bbb1
  OPTION: a with arg: `'
  OPTION: b with arg: `bbb1'
  OPTIND: 4
  $ test "$opt" = '?'

No option:

  $ reset_getopts
  $ test_standard_1 arg1 arg2 args
  OPTIND: 1
  $ test "$opt" = '?'

OPTARG is **unset** at every invocation of `getopts` first:

  $ reset_getopts
  $ test_standard_1 -a -b bbb1 -a
  OPTION: a with arg: `'
  OPTION: b with arg: `bbb1'
  OPTION: a with arg: `'
  OPTIND: 5

Option arguments are not checked for another option syntax:

  $ reset_getopts
  $ test_standard_1 -a -b -a
  OPTION: a with arg: `'
  OPTION: b with arg: `-a'
  OPTIND: 4


Missing arguments:

  $ reset_getopts
  $ test_standard_1 -b
  No arg for -b option
  ERROR: unknown option
  OPTIND: 2
  $ test "$opt" = '?'

No abort on errors:

  $ reset_getopts
  $ test_standard_1 -u -a
  Illegal option -u
  ERROR: unknown option
  OPTION: a with arg: `'
  OPTIND: 3
  $ test "$opt" = '?'

Abort processing with '--'

  $ reset_getopts
  $ test_standard_1 -a -b xxx -- -a -b yyy
  OPTION: a with arg: `'
  OPTION: b with arg: `xxx'
  OPTIND: 5
  $ test "$opt" = '?'

'--' does not stop option processing when a required arg just before is missing

  $ reset_getopts
  $ test_standard_1 -a -b -- -a -b yyy
  OPTION: a with arg: `'
  OPTION: b with arg: `--'
  OPTION: a with arg: `'
  OPTION: b with arg: `yyy'
  OPTIND: 7


No Error Reports
================

This behaviour with a colon as the very first character in optstring is not
documented. But it works similar to ksh93.

  $ reset_getopts
  $ test_noreport_1 -a -b bbb1
  OPTION: a with arg: `'
  OPTION: b with arg: `bbb1'
  OPTIND: 4

The variable will be set to ``?`` after the last option when getopts returns 1:

  $ reset_getopts
  $ test_standard_1 -a -b bbb1
  OPTION: a with arg: `'
  OPTION: b with arg: `bbb1'
  OPTIND: 4
  $ test "$opt" = '?'

No option:

  $ reset_getopts
  $ test_noreport_1 arg1 arg2 args
  OPTIND: 1
  $ test "$opt" = '?'

OPTARG is **unset** at every invocation of `getopts` first:

  $ reset_getopts
  $ test_noreport_1 -a -b bbb1 -a
  OPTION: a with arg: `'
  OPTION: b with arg: `bbb1'
  OPTION: a with arg: `'
  OPTIND: 5

Option arguments are not checked for another option syntax:

  $ reset_getopts
  $ test_noreport_1 -a -b -a
  OPTION: a with arg: `'
  OPTION: b with arg: `-a'
  OPTIND: 4

Here FreeBSD's `/bin/sh` behaves like `ksh93`

Missing arguments are reported via ':' here:

  $ reset_getopts
  $ test_noreport_1 -b
  ERROR: unknown option (colon): b
  OPTIND: 2
  $ test "$opt" = '?'

No abort on errors -- unknown options are reported via '?' here:

  $ reset_getopts
  $ test_noreport_1 -u -a
  ERROR: unknown option: u
  OPTION: a with arg: `'
  OPTIND: 3
  $ test "$opt" = '?'

Abort processing with '--'

  $ reset_getopts
  $ test_noreport_1 -a -b xxx -- -a -b yyy
  OPTION: a with arg: `'
  OPTION: b with arg: `xxx'
  OPTIND: 5

'--' does not stop option processing when a required arg just before is missing

  $ reset_getopts
  $ test_noreport_1 -a -b -- -a -b yyy
  OPTION: a with arg: `'
  OPTION: b with arg: `--'
  OPTION: a with arg: `'
  OPTION: b with arg: `yyy'
  OPTIND: 7
