# Configuration file for the Sphinx documentation builder.
#
# This file only contains a selection of the most common options. For a full
# list see the documentation:
# https://www.sphinx-doc.org/en/master/usage/configuration.html

# -- Path setup --------------------------------------------------------------

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
#
import os
import re
# import sys
# sys.path.insert(0, os.path.abspath('.'))


# -- Project information -----------------------------------------------------

project = 'local-bsdtools'
copyright = '2017-2022, Franz Glasner'
author = 'Franz Glasner'

# The full version, including alpha/beta/rc tags
with open(os.path.join(os.path.dirname(__file__),
                       "..",
                       "Makefile"), "rb") as f:
    release = re.search(b"^PORTVERSION\s*=\s*(\S+)",
                        f.read(),
                        re.MULTILINE).group(1).decode("ascii")


# -- General configuration ---------------------------------------------------

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = [
]

# Add any paths that contain templates here, relative to this directory.
templates_path = ['_templates']

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This pattern also affects html_static_path and html_extra_path.
exclude_patterns = ['_build', 'Thumbs.db', '.DS_Store']


# -- Options for HTML output -------------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
#
html_theme = 'haiku'

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ['_static']

html_show_sourcelink = False

# For the Haiku title
html_short_title = "%s %s" % (project, release)


# -- Options for manual page output ------------------------------------------

# One entry per manual page. List of tuples
# (source start file, name, description, authors, manual section).
man_pages = [
    ("man/man8/local-bsdtools", "local-bsdtools", 'FreeBSD administration helper tools v%s' % release, [author], 8),
    ("man/man8/bsmtp2dma", "bsmtp2dma", "Bacula compatible mail submission program", [author], 8),
    ("man/man8/fjail", "fjail", "Management of jails", [author], 8),
    #("man/man8/fjail-copy", "fjail-copy", "Recursively copy ZFS datasets including all properties", [author], 8),
    #("man/man8/fjail-datasets", "fjail-datasets", "Create a new tree of ZFS datasets that will encompass a jail", [author], 8),
    #("man/man8/fjail-hostid", "fjail-hostid", "Compute a proposal for a new BSD Host UUID and ID", [author], 8),
    #("man/man8/fjail-mount", "fjail-mount", "Recursively mount a ZFS dataset and its children", [author], 8),
    #("man/man8/fjail-populate", "fjail-populate", "Populate a directory with content from a FreeBSD base.txz", [author], 8),
    #("man/man8/fjail-privs", "fjail-privs", "Adjust some privileges within a mounted jail", [author], 8),
    #("man/man8/fjail-umount", "fjail-umount", "Recursively unmount a ZFS datasets and its children", [author], 8),
    ("man/man8/fpkg", "fpkg", "A frontend for some pkg(8) commands that also operate on running jails", [author], 8),
    ("man/man8/ftjail", "ftjail", "Management of Thin Jails", [author], 8),
    ("man/man8/ftjail-build-etcupdate-current-tmpl", "ftjail-build-etcupdate-current-tmpl", "Build a \"current\" tree suitable for the default and extract mode of \"etcupdate\"", [author], 8),
    ("man/man8/ftjail-copy-skel", "ftjail-copy-skel", "Recursively copy skeleton contents", [author], 8),
    ("man/man8/ftjail-datasets-tmpl", "ftjail-datasets-tmpl", "Create ZFS datasets for new Thin Jails using base and skeleton", [author], 8),
    ("man/man8/ftjail-interlink-tmpl", "ftjail-interlink-tmpl", "Create proper symlinks for \"skeleton\" style Thin Jails", [author], 8),
    ("man/man8/ftjail-mount-tmpl", "ftjail-mount-tmpl", "Canonically mount the RO base and the RW skeleton of a Thin Jail", [author], 8),
("man/man8/ftjail-populate-tmpl", "ftjail-populate-tmpl", "Populate a prepared directory structure with the contents of a FreeBSD base system", [author], 8),
    ("man/man8/ftjail-snapshot-tmpl", "ftjail-snapshot-tmpl", "Recursively create ZFS snapshots of the RO base datasets and the RW skeleton datasets", [author], 8),
    ("man/man8/ftjail-umount-tmpl", "ftjail-umount-tmpl", "Unmount mounted Thin Jail template datasets", [author], 8),
    ("man/man8/fzfs", "fzfs", "A ZFS management helper tool", [author], 8),
    ("man/man8/fzfs-mount", "fzfs-mount", "Recursively mount a ZFS dataset and its children", [author], 8),
    ("man/man8/fzfs-umount", "fzfs-umount", "Recursively unmount a ZFS datasets and its children", [author], 8),
]


# -- Link to manual pages ----------------------------------------------------

manpages_url = "https://www.freebsd.org/cgi/man.cgi?query={page}&sektion={section}"
