Basic tests of common.subr

Shell is /bin/sh.


Setup
=====

  $ set -u
  $ . "${TESTDIR}/testsetup.sh"
  $ _p_datadir="${TESTDIR}/../share/local-bsdtools"
  $ . "${_p_datadir}/common.subr"


Getopts
=======

Normal successfull calls

  $ error=''
  > opt_a=no
  > opt_b=no
  > unset opt_b_val
  > OPTIND=1
  > while getopts "ab:-:" opt --long-a --long-b=value-of-b arg ; do
  >   postprocess_getopts_for_long "ab:-:" opt "long-a" "long-b=" "" --long-b=value-of-b arg
  >    case "$opt" in
  >      a|long-a) opt_a=yes
  >                [ -z "${OPTARG+SET}" ] || echo "ERROR: OPTARG"
  >                ;;
  >      b|long-b) opt_b=yes
  >                [ -n "${OPTARG+SET}" ] || echo "ERROR: OPTARG"
  >                opt_b_val="${OPTARG}"
  >                ;;
  >      \?)
  >                error=foo
  >                ;;
  >      *)
  >                error=bar
  >                ;;
  >    esac
  > done

  $ checkyesno opt_a
  $ checkyesno opt_b
  $ [ "${opt_b_val}" = "value-of-b" ]
  $ [ -z "${error}" ]

Not null-terminated long options specifications

  $ OPTIND=1
  > getopts "ab:-:" opt --long-a --long-b arg
  > postprocess_getopts_for_long "ab:-:" opt "long-a" "long-b"
  /bin/sh: ERROR: Missing null terminator for long option specifications
  [64]
  $ [ -z "${opt}" ]
  $ [ -z "${OPTARG+SET}" ]

Not null-terminated long options specs (alternate error handling)

  $ OPTIND=1
  > getopts ":ab:-:" opt --long-a --long-b arg
  > postprocess_getopts_for_long ":ab:-:" opt "long-a" "long-b"
  /bin/sh: ERROR: Missing null terminator for long option specifications
  [64]
  $ [ -z "${opt}" ]
  $ [ -z "${OPTARG+SET}" ]

Illegal long option

  $ error=''
  > opt_a=no
  > opt_b=no
  > unset opt_b_val
  > OPTIND=1
  > while getopts "ab:-:" opt --long-unknown ; do
  >   postprocess_getopts_for_long "ab:-:" opt "long-a" "long-b=" "" --long-unknown
  >    case "$opt" in
  >      a|long-a) opt_a=yes
  >                [ -z "${OPTARG+SET}" ] || echo "ERROR: OPTARG"
  >                ;;
  >      b|long-b) opt_b=yes
  >                [ -n "${OPTARG+SET}" ] || echo "ERROR: OPTARG"
  >                opt_b_val="${OPTARG}"
  >                ;;
  >      \?)
  >                error=foo
  >                ;;
  >      *)
  >                error=bar
  >                ;;
  >    esac
  > done
  /bin/sh: ERROR: Illegal option --long-unknown
  $ [ "${error}" = "foo" ]

Illegal long option (alternate error handling)

  $ error=''
  > opt_a=no
  > opt_b=no
  > unset opt_b_val
  > OPTIND=1
  > while getopts ":ab:-:" opt --long-unknown ; do
  >   postprocess_getopts_for_long ":ab:-:" opt "long-a" "long-b=" "" --long-unknown
  >    case "$opt" in
  >      a|long-a) opt_a=yes
  >                [ -z "${OPTARG+SET}" ] || echo "ERROR: OPTARG"
  >                ;;
  >      b|long-b) opt_b=yes
  >                [ -n "${OPTARG+SET}" ] || echo "ERROR: OPTARG"
  >                opt_b_val="${OPTARG}"
  >                ;;
  >      \?)
  >                error="${OPTARG}"
  >                ;;
  >      *)
  >                error=bar
  >                ;;
  >    esac
  > done
  $ [ "${error}" = "long-unknown" ]

Missing required option argument

  $ error=''
  > opt_a=no
  > opt_b=no
  > unset opt_b_val
  > OPTIND=1
  > while getopts "ab:-:" opt --long-a --long-b arg ; do
  >   postprocess_getopts_for_long "ab:-:" opt "long-a" "long-b=" "" --long-b arg
  >    case "$opt" in
  >      a|long-a) opt_a=yes
  >                [ -z "${OPTARG+SET}" ] || echo "ERROR: OPTARG"
  >                ;;
  >      b|long-b) opt_b=yes
  >                [ -n "${OPTARG+SET}" ] || echo "ERROR: OPTARG"
  >                opt_b_val="${OPTARG}"
  >                ;;
  >      ?)
  >                error=foo
  >                ;;
  >      *)
  >                error=bar
  >                ;;
  >    esac
  > done
  /bin/sh: ERROR: option argument required for option --long-b
  $ [ "${error}" = "foo" ]

Missing required option argument (alternate error handling)

  $ error=''
  > opt_a=no
  > opt_b=no
  > unset opt_b_val
  > OPTIND=1
  > while getopts ":ab:-:" opt --long-a --long-b arg ; do
  >   postprocess_getopts_for_long ":ab:-:" opt "long-a" "long-b=" "" --long-b arg
  >    case "$opt" in
  >      a|long-a) opt_a=yes
  >                [ -z "${OPTARG+SET}" ] || echo "ERROR: OPTARG"
  >                ;;
  >      b|long-b) opt_b=yes
  >                [ -n "${OPTARG+SET}" ] || echo "ERROR: OPTARG"
  >                opt_b_val="${OPTARG}"
  >                ;;
  >      :)
  >                error="${OPTARG}"
  >                ;;
  >      *)
  >                error=bar
  >                ;;
  >    esac
  > done
  $ [ "${error}" = "long-b" ]

Option argument value not allowed

  $ error=''
  > opt_a=no
  > opt_b=no
  > unset opt_b_val
  > OPTIND=1
  > while getopts "ab:-:" opt --long-a=a-value  arg ; do
  >   postprocess_getopts_for_long "ab:-:" opt "long-a" "long-b=" "" --long-a=a-value arg
  >    case "$opt" in
  >      a|long-a) opt_a=yes
  >                [ -z "${OPTARG+SET}" ] || echo "ERROR: OPTARG"
  >                ;;
  >      b|long-b) opt_b=yes
  >                [ -n "${OPTARG+SET}" ] || echo "ERROR: OPTARG"
  >                opt_b_val="${OPTARG}"
  >                ;;
  >      ?)
  >                error=foo
  >                ;;
  >      *)
  >                error=bar
  >                ;;
  >    esac
  > done
  /bin/sh: ERROR: no option argument allowed for option --long-a
  $ [ "${error}" = "foo" ]

Missing required option argument (alternate error handling)

  $ error=''
  > opt_a=no
  > opt_b=no
  > unset opt_b_val
  > OPTIND=1
  > while getopts ":ab:-:" opt --long-a=a-value  arg ; do
  >   postprocess_getopts_for_long ":ab:-:" opt "long-a" "long-b=" "" --long-a=a-value arg
  >    case "$opt" in
  >      a|long-a) opt_a=yes
  >                [ -z "${OPTARG+SET}" ] || echo "ERROR: OPTARG"
  >                ;;
  >      b|long-b) opt_b=yes
  >                [ -n "${OPTARG+SET}" ] || echo "ERROR: OPTARG"
  >                opt_b_val="${OPTARG}"
  >                ;;
  >      :)
  >                error="${OPTARG}"
  >                ;;
  >      *)
  >                error=bar
  >                ;;
  >    esac
  > done
  $ [ "${error}" = "long-a" ]

Invalid character in long option

  $ error=''
  > OPTIND=1
  > getopts "ab:-:" opt --long=a
  > postprocess_getopts_for_long "ab:-:" opt "long=a" "" --long=a arg
  /bin/sh: ERROR: Long option specification contains a forbidden `=' character: long=a
  [64]
  $ [ -z "${opt}" ]
  $ [ -z "${OPTARG+SET}" ]

Invalid character in long option (alternate error handling)

  $ error=''
  > OPTIND=1
  > getopts ":a-:" opt --long=a
  > postprocess_getopts_for_long ":a-:" opt "long=a" "" --long=a arg
  /bin/sh: ERROR: Long option specification contains a forbidden `=' character: long=a
  [64]
  $ [ -z "${opt}" ]
  $ [ -z "${OPTARG+SET}" ]

Invalid character in long option

  $ error=''
  > OPTIND=1
  > getopts "b:-:" opt --long=a
  > postprocess_getopts_for_long "b:-:" opt "long=b=" "" --long=b=value arg
  /bin/sh: ERROR: Long option specification contains a forbidden `=' character: long=b=
  [64]
  $ [ -z "${opt}" ]
  $ [ -z "${OPTARG+SET}" ]

Invalid character in long option (alternate error handling)

  $ error=''
  > OPTIND=1
  > getopts ":b:-:" opt --long=a
  > postprocess_getopts_for_long ":b:-:" opt "long=b=" "" --long=b=value arg
  /bin/sh: ERROR: Long option specification contains a forbidden `=' character: long=b=
  [64]
  $ [ -z "${opt}" ]
  $ [ -z "${OPTARG+SET}" ]