#!/bin/sh

# How to create the basic template datasets for thin jails

_symlink="-P"

FTJAIL="/home/fag/work/ports/sysutils/local-bsdtools/sbin/ftjail"

"$FTJAIL" datasets-tmpl $_symlink zpool/var/tmp/jails/base-ro zpool/var/tmp/jails/skel-rw test1

"$FTJAIL" mount-tmpl $_symlink zpool/var/tmp/jails/base-ro/test1 zpool/var/tmp/jails/skel-rw/test1 /var/tmp/T1

zfs list -r -o name,canmount,atime,sync,exec,setuid,compression,mountpoint zpool/var/tmp/jails

mount

"$FTJAIL" populate-tmpl $_symlink /var/tmp/T1 /root/pkg/base-12.3.txz

if [ "$_symlink" = "-L" ]; then
    "$FTJAIL" interlink-tmpl /var/tmp/T1
fi

"$FTJAIL" snapshot-tmpl zpool/var/tmp/jails/base-ro/test1 zpool/var/tmp/jails/skel-rw/test1 12.3-RELEASE

# Create the jail root filesystem by cloning the base RO in read-only mode
# zfs clone -o readonly=on -o mountpoint=/here/are/my/jails/the-jail -o canmount=noauto|on zpool/var/tmp/jails/base-ro/test1@12.3-RELEASE zpool/var/tmp/jails/the-jail

