Basic tests of farray.sh's falist_XXX functions

Shell is /bin/sh.


Setup
=====

  $ set -u
  $ . "${TESTDIR}/testsetup.sh"
  $ _p_datadir="${TESTDIR}/../share/local-bsdtools"
  $ . "${_p_datadir}/farray.sh"


Basic Creation and Destruction
==============================

Create an empty alist

  $ falist_create LIST
  $ falist_length _i LIST
  $ echo "$_i"
  0
  $ test "${_i}" -eq 0
  $ falist_print_length LIST
  0 (no-eol)

  $ falist_debug LIST
  DEBUG: alist `LIST' has length 0

  $ falist_destroy LIST
  $ ( falist_destroy LIST )
  ERROR: falist `LIST' not created properly: token empty
  [1]

  $ check_no_alist_artifacts


Clear
=====

  $ falist_create LIST
  $ falist_set LIST K1 V1
  $ falist_set LIST K2 V2
  $ falist_debug LIST
  DEBUG: alist `LIST' has length 2
  DEBUG:     `K1' -> `V1'
  DEBUG:     `K2' -> `V2'
  $ falist_length _i LIST
  $ echo "$_i"
  2
  $ falist_print_length LIST
  2 (no-eol)

  $ falist_clear LIST
  $ falist_length _i LIST
  $ echo "$_i"
  0
  $ falist_print_length LIST
  0 (no-eol)

  $ falist_destroy LIST
  $ check_no_alist_artifacts


Get / Set / Contains
====================

  $ falist_create LIST
  $ falist_set LIST K1 V1
  $ falist_set LIST K2 V2
  $ falist_debug LIST
  DEBUG: alist `LIST' has length 2
  DEBUG:     `K1' -> `V1'
  DEBUG:     `K2' -> `V2'
  $ falist_length _i LIST
  $ echo "$_i"
  2
  $ falist_print_length LIST
  2 (no-eol)

  $ falist_set LIST K2 "V2 2"
  $ falist_set LIST K3 $'" 111222333" \\\'444555 '    # '
  $ falist_debug LIST
  DEBUG: alist `LIST' has length 3
  DEBUG:     `K1' -> `V1'
  DEBUG:     `K2' -> `V2 2'
  DEBUG:     `K3' -> `" 111222333" \'444555 '
  $ falist_length _i LIST
  $ echo "$_i"
  3
  $ falist_print_length LIST
  3 (no-eol)

  $ falist_contains LIST K1
  $ falist_contains LIST K
  [1]
  $ falist_get _var LIST K2
  $ echo "$_var"
  V2 2
  $ falist_tryget _var LIST K1
  $ echo "$_var"
  V1
  $ falist_tryget _i LIST K
  [1]
  $ _var="$(falist_print_length NON_EXISTING_LIST)"
  ERROR: falist `NON_EXISTING_LIST' not created properly: token empty
  $ echo "${_var}"
  -1

  $ falist_destroy LIST
  $ check_no_alist_artifacts


Iteration
=========

ITERATE (manual indexing)

  $ falist_create LIST
  $ falist_set LIST K1 V1
  $ falist_set LIST K2 "V2 2"
  $ falist_set LIST K3 $'" 111222333" \\\'444555 '    # '

Iteration by indexing key and values separately

  $ _i=1
  > while falist_tryget_key_at_index _k LIST ${_i}; do
  >     # cannot fail under "normal" circumstances
  >     falist_tryget_value_at_index _v LIST ${_i}
  >     printf "  KEY: \`%s', VAL: \`%s'\\n" "${_k}" "${_v}"
  >     _i=$((_i + 1))
  > done
    KEY: `K1', VAL: `V1'
    KEY: `K2', VAL: `V2 2'
    KEY: `K3', VAL: `" 111222333" \'444555 '

ITERATE (manual indexing over items)

  $ _i=1
  > while falist_tryget_item_at_index _k _v LIST ${_i}; do
  >     printf "  KEY: \`%s', VAL: \`%s'\\n" "${_k}" "${_v}"
  >     _i=$((_i + 1))
  > done
    KEY: `K1', VAL: `V1'
    KEY: `K2', VAL: `V2 2'
    KEY: `K3', VAL: `" 111222333" \'444555 '

ITERATE (for each)

  $ falist_for_each LIST $'printf "EACH: %s key \\`%s\\\', value \\`%s\\\' at idx %d\\n"'   # `
  EACH: LIST key `K1', value `V1' at idx 1
  EACH: LIST key `K2', value `V2 2' at idx 2
  EACH: LIST key `K3', value `" 111222333" \'444555 ' at idx 3

  $ falist_clear LIST
  $ falist_destroy LIST
  $ falist_destroy LIST
  ERROR: falist `LIST' not created properly: token empty
  [1]


Deletion of keys
================

  $ falist_create LIST
  $ falist_set LIST 'key 1' 'value 1'
  $ falist_set LIST 'key 2' 'value 2'
  $ falist_set LIST 'key 3' 'value 3'
  $ falist_set LIST 'key 4' 'value 4'
  $ falist_set LIST 'key 5' 'value 5'
  $ falist_trydel LIST 'key 1'
  $ falist_trydel LIST 'key 5'
  $ falist_trydel LIST 'key 3'
  $ falist_trydel LIST "non-existing key"
  [1]
  $ falist_print_length LIST
  2 (no-eol)
  $ falist_get _var LIST 'key 2'
  $ printf '%s' "$_var"
  value 2 (no-eol)
  $ falist_get _var LIST 'key 4'
  $ printf '%s' "$_var"
  value 4 (no-eol)

  $ falist_destroy LIST

  $ check_no_alist_artifacts
