Basic tests of farray.sh's farray_XXX functions

Shell is /bin/sh.

Setup
=====

  $ . "${TESTDIR}/testsetup.sh"
  $ _p_datadir="${TESTDIR}/../share/local-bsdtools"
  $ . "${_p_datadir}/farray.sh"


Basic Creation and Destruction
==============================

Create an empty array

  $ farray_create EMPTY
  $ farray_print_length EMPTY
  0 (no-eol)
  $ farray_length _var EMPTY
  $ test ${_var} -eq 0
  $ farray_debug EMPTY
  DEBUG: array `EMPTY' has length 0
  $ farray_destroy EMPTY
  $ check_no_array_artifacts

Create and destroy an array

  $ farray_create TEST 0 1 2 '3  4   5' $'" 678" \\\'90 '
  $ farray_print_length TEST
  5 (no-eol)
  $ farray_length _var TEST
  $ test ${_var} -eq 5
  $ farray_debug TEST
  DEBUG: array `TEST' has length 5
  DEBUG:   its contents:
  DEBUG:     1: `0'
  DEBUG:     2: `1'
  DEBUG:     3: `2'
  DEBUG:     4: `3  4   5'
  DEBUG:     5: `" 678" \'90 '
  $ farray_destroy TEST
  $ check_no_array_artifacts

Create, clear and destroy an array

  $ farray_create TEST 0 1 2 '3  4   5' $'" 678" \\\'90 '
  $ farray_print_length TEST
  5 (no-eol)
  $ farray_length _var TEST
  $ test ${_var} -eq 5
  $ farray_debug TEST
  DEBUG: array `TEST' has length 5
  DEBUG:   its contents:
  DEBUG:     1: `0'
  DEBUG:     2: `1'
  DEBUG:     3: `2'
  DEBUG:     4: `3  4   5'
  DEBUG:     5: `" 678" \'90 '
  $ farray_clear TEST
  $ farray_print_length TEST
  0 (no-eol)
  $ farray_length _var TEST
  $ test ${_var} -eq 0
  $ farray_destroy TEST
  $ check_no_array_artifacts

Duplicate destruction

  $ farray_create TEST 1 2 3
  $ farray_destroy TEST
  $ farray_destroy TEST
  ERROR: farray `TEST' does not exist: token empty
  [1]
  $ check_no_array_artifacts

Equality
========

Equality (empty)

  $ farray_create TEST1
  $ farray_create TEST2
  $ farray_are_equal TEST1 TEST2
  $ farray_destroy TEST1
  $ farray_destroy TEST2
  $ check_no_array_artifacts

Equality (non-empty)

  $ farray_create TEST1 0 1 2 '3  4   5' $'" 678" \\\'90 '
  $ farray_create TEST2 0 1 2 '3  4   5' $'" 678" \\\'90 '
  $ farray_are_equal TEST1 TEST2
  $ farray_destroy TEST1
  $ farray_destroy TEST2
  $ check_no_array_artifacts

In-Equality (non-empty, same length)

  $ farray_create TEST1 0 1 2 '3  4   5' $'" 678" \\\'90 '
  $ farray_create TEST2 0 1 2 '3  4   5' $'" 678" \\\'90'
  $ farray_are_equal TEST1 TEST2
  [1]
  $ farray_destroy TEST1
  $ farray_destroy TEST2
  $ check_no_array_artifacts

In-Equality (non-empty, different length)

  $ farray_create TEST1 0 1 2 '3  4   5' $'" 678" \\\'90 '
  $ farray_create TEST2   1 2 '3  4   5' $'" 678" \\\'90 '
  $ farray_are_equal TEST1 TEST2
  [1]
  $ farray_destroy TEST1
  $ farray_destroy TEST2
  $ check_no_array_artifacts
