Basic tests of farray.sh's internal helper functions

Shell is /bin/sh.


Setup
=====

  $ set -u
  $ . "${TESTDIR}/testsetup.sh"
  $ _p_datadir="${TESTDIR}/../share/local-bsdtools"
  $ . "${_p_datadir}/farray.sh"


Plain Decimal Number Checks
===========================

Valid
-----

  $ _farr_is_decimal_number 0
  $ _farr_is_decimal_number 12345678901234567890
  $ _farr_is_decimal_number -12345678901234567890
  $ _farr_is_decimal_number +12345678901234567890

Octal

  $ _farr_is_decimal_number 01234567012345670
  $ _farr_is_decimal_number -01234567012345670
  $ _farr_is_decimal_number +01234567012345670


Invalid
-------

  $ _farr_is_decimal_number x
  [1]
  $ _farr_is_decimal_number ''
  [1]
  $ _farr_is_decimal_number '+'
  [1]
  $ _farr_is_decimal_number '-'
  [1]
  $ _farr_is_decimal_number '0x1'
  [1]
  $ _farr_is_decimal_number '/'
  [1]
  $ _farr_is_decimal_number *12345678901234567890
  [1]
  $ _farr_is_decimal_number 0x0123456789abcdef
  [1]
  $ _farr_is_decimal_number 0123456789abcdef
  [1]
  $ _farr_is_decimal_number 01234567890
  [1]
  $ _farr_is_decimal_number -01234567890
  [1]
  $ _farr_is_decimal_number +01234567890
  [1]


Index Checks
============

  $ _farr_make_index _res 5
  $ echo $_res
  5

  $ _farr_make_index _res "" 123
  $ echo $_res
  124

  $ _farr_make_index _res 0 123
  $ echo $_res
  123

  $ _farr_make_index _res -122 123
  $ echo $_res
  1

  $ _farr_make_index _res -123 123
  $ echo $_res
  0

  $ _farr_make_index _res 124 123
  $ echo $_res
  124

  $ _farr_make_index _res 125 123
  $ echo $_res
  125

  $ ( _farr_make_index _res 0 )
  ERROR: cannot compute effective index because no length is given
  [70]

  $ ( _farr_make_index _res "" )
  ERROR: length not given: cannot autocompute index
  [70]

  $ ( _farr_make_index _res 0x1 )
  ERROR: given index is not a valid decimal number
  [70]

  $ ( _farr_make_index _res 0 0x1 )
  ERROR: given length is not a valid decimal number
  [70]


Storage Pointer Checks
======================

No empty (null) values

  $ _farr_is_valid_storage_ptr ''
  [1]

The NULL pointer (aka s single 0 character) is allowed

  $ _farr_is_valid_storage_ptr 0

Non-decimal charactesr are not allowed

  $ _farr_is_valid_storage_ptr f12345
  [1]

  $ _farr_is_valid_storage_ptr a
  [1]

  $ _farr_is_valid_storage_ptr '/'
  [1]

"Octal" numbers are not allowed

  $ _farr_is_valid_storage_ptr 01
  [1]

Some valid numbers

  $ _farr_is_valid_storage_ptr 1
  $ _farr_is_valid_storage_ptr 2
  $ _farr_is_valid_storage_ptr 3
  $ _farr_is_valid_storage_ptr 4
  $ _farr_is_valid_storage_ptr 5
  $ _farr_is_valid_storage_ptr 6
  $ _farr_is_valid_storage_ptr 7
  $ _farr_is_valid_storage_ptr 8
  $ _farr_is_valid_storage_ptr 9

  $ _farr_is_valid_storage_ptr 12345678901234567890
