Basic tests of ports.subr

Shell is /bin/sh


Setup
=====

We need common.subr and ports.subr

  $ set -u
  $ . "${TESTDIR}/testsetup.sh"
  $ _p_datadir="${TESTDIR}/../share/local-bsdtools"
  $ . "${_p_datadir}/farray.sh"
  $ . "${_p_datadir}/common.subr"
  $ . "${_p_datadir}/ports.subr"


Package Mapping
===============

init_package_mapping
--------------------

  $ init_package_mapping PMAPPING ""


get_package_mapping
-------------------

An empty database errors fatally

  $ (get_package_mapping '' whatever-package)
  ERROR: missing falist name or token value
  [70]

Empty package name errors fatally

  $ (get_package_mapping PMAPPING)
  /bin/sh: ERROR: missing package name
  [64]

  $ get_package_mapping PMAPPING install-package
  parent-package (no-eol)

This is the target of the mapping

  $ get_package_mapping PMAPPING parent-package
  [1]

Another package

  $ get_package_mapping PMAPPING install-package-v2
  parent-package-v2 (no-eol)

Commented out

  $ get_package_mapping PMAPPING install-package-v3
  [1]


Local Index File
================

Assumes fag's standard: PORTSDIR=/home/fag/ports

  $ is_local_index_file_available ""
  $ PORTSDIR=/nonexisting is_local_index_file_available ""
  [1]
  $ export VERSION_SOURCE=I
  $ is_local_index_file_available ""
  [1]
  $ export VERSION_SOURCE=P
  $ is_local_index_file_available ""
  $ unset VERSION_SOURCE

  $ get_local_index_file ""
  /home/fag/ports/INDEX-[0-9]+ \(no-eol\) (re)
  $ PORTSDIR=/nonexisting get_local_index_file ""
  [1]
  $ export VERSION_SOURCE=I
  $ get_local_index_file ""
  [1]
  $ export VERSION_SOURCE=P
  $ get_local_index_file ""
  /home/fag/ports/INDEX-[0-9]+ \(no-eol\) (re)
  $ unset VERSION_SOURCE

  $ _pkgversion="$(parse_index_file_for_package_version "$(get_local_index_file "")" 'pkg' '')"
  $ [ -n "${_pkgversion}" ]
  $ printf '%s' "${_pkgversion}"
  \d+\.\d+(\.\d+) \(no-eol\) (re)


Repositories
============

Assume that FreeBSD is always configured and enabled

  $ get_configured_pkg_repository_names | grep -F FreeBSD
  FreeBSD


# Runtime much too long: need another strategy
#  $ REPODB=''
#  $ init_repositories REPODB
