#!/bin/sh
#
# Test helpers for the shell unittests using cram.
#


#:
#: Set some directories to temporary values for inclusion of test configuration
#: files.
#:
CONFIGDIR="${TESTDIR}/etc"
PACKAGE_MAPPING="${CONFIGDIR}/package-mapping.conf"


#:
#: Check that no global variables that hold any array storage are left.
#:
#: Returns:
#:   int: 0 if no unexpected storage is left, 1 otherwise
#:
check_no_array_artifacts() {
    # _farr_A_ is the storage prefix for arrays
    if set | grep -E -e '^_farr_A_.*='; then
	return 1
    else
	return 0
    fi
}


#:
#: Check that no global variables that hold any alist storage are left.
#:
#: Returns:
#:   int: 0 if no unexpected storage is left, 1 otherwise
#:
check_no_alist_artifacts() {
    # This are all _farr_alist_XXX_prefix variables
    if set | grep -E -e '^_farr_KV_.*=' -e '^_farr_Kb_.*=' -e '^_farr_Ks_.*=' -e '^_farr_Vs_.*='; then
	return 1
    else
	return 0
    fi
}


#:
#: Check that no local variables are globally visible.
#:
#: Because all local variables have the ``__farr_`` prefix it can easily
#: checked that no forgotten "local" declarations exist.
#:
check_no_local_artifacts() {
    if set | grep -E -e '^__farr.*='; then
	return 1
    else
	return 0
    fi
}
