Basic tests of ports.subr

Shell is /bin/sh


Setup
=====

We need common.subr and ports.subr

  $ set -u
  $ . "${TESTDIR}/testsetup.sh"
  $ _p_datadir="${TESTDIR}/../share/local-bsdtools"
  $ . "${_p_datadir}/farray.sh"
  $ . "${_p_datadir}/common.subr"
  $ . "${_p_datadir}/ports.subr"


Package Mapping
===============

init_package_mapping
--------------------

  $ init_package_mapping PMAPPING


get_package_mapping
-------------------

An empty database errors fatally

  $ (get_package_mapping '' whatever-package)
  ERROR: missing falist name or token value
  [70]

Empty package name errors fatally

  $ (get_package_mapping PMAPPING)
  /bin/sh: ERROR: missing package name
  [64]

  $ get_package_mapping PMAPPING install-package
  parent-package (no-eol)

This is the target of the mapping

  $ get_package_mapping PMAPPING parent-package
  [1]

Another package

  $ get_package_mapping PMAPPING install-package-v2
  parent-package-v2 (no-eol)

Commented out

  $ get_package_mapping PMAPPING install-package-v3
  [1]


Repositories
============

Assume that FreeBSD is always configured and enabled

  $ get_configured_pkg_repository_names | grep -F FreeBSD
  FreeBSD


# Runtime much too long: need another strategy
#  $ REPODB=''
#  $ init_repositories REPODB
