--- src/apps/relay/hiredis_libevent2.c.orig	2024-12-11 18:13:38 UTC
+++ src/apps/relay/hiredis_libevent2.c
@@ -52,6 +52,7 @@ struct redisLibeventEvents {
   int port;
   char *user;
   char *pwd;
+  char *usocket;
   int db;
 };
 
@@ -213,8 +214,10 @@ void send_message_to_redis(redis_context_handle rch, c
 
 ///////////////////////// Attach /////////////////////////////////
 
-redis_context_handle redisLibeventAttach(struct event_base *base, char *ip0, int port0, char *user, char *pwd, int db) {
+redis_context_handle redisLibeventAttach(struct event_base *base, char *ip0, int port0, char *usocket, char *user, char *pwd, int db) {
 
+  redisAsyncContext *ac = NULL;
+  char sockpath[256] = "\0";
   char ip[256];
   if (ip0 && ip0[0]) {
     STRCPY(ip, ip0);
@@ -227,7 +230,11 @@ redis_context_handle redisLibeventAttach(struct event_
     port = port0;
   }
 
-  redisAsyncContext *ac = redisAsyncConnect(ip, port);
+  if(usocket && usocket[0]) {
+    ac = redisAsyncConnectUnix(sockpath);
+  } else {
+    ac = redisAsyncConnect(ip, port);
+  }
   if (!ac) {
     fprintf(stderr, "Error: redisAsyncConnect returned NULL\n");
     return NULL;
@@ -253,6 +260,9 @@ redis_context_handle redisLibeventAttach(struct event_
   if (pwd) {
     e->pwd = strdup(pwd);
   }
+  if (usocket) {
+    e->usocket = strdup(usocket);
+  }
   e->db = db;
 
   /* Register functions to start/stop listening for events */
@@ -270,6 +280,16 @@ redis_context_handle redisLibeventAttach(struct event_
   e->wev = event_new(e->base, e->context->c.fd, EV_WRITE, redisLibeventWriteEvent, e);
 
   if (e->rev == NULL || e->wev == NULL) {
+    if (e->rev) {
+      event_free(e->rev);
+    }
+    if (e->wev) {
+      event_free(e->wev);
+    }
+    free(e->ip);
+    free(e->usocket);
+    free(e->user);
+    free(e->pwd);
     free(e);
     return NULL;
   }
@@ -329,7 +349,11 @@ static void redis_reconnect(struct redisLibeventEvents
     e->context = NULL;
   }
 
-  ac = redisAsyncConnect(e->ip, e->port);
+  if(e->usocket) {
+    ac = redisAsyncConnectUnix(e->usocket);
+  } else {
+    ac = redisAsyncConnect(e->ip, e->port);
+  }
   if (!ac) {
     return;
   }
