--- src/apps/common/hiredis_libevent2.c.orig	2021-01-10 19:59:55 UTC
+++ src/apps/common/hiredis_libevent2.c
@@ -55,6 +55,7 @@ struct redisLibeventEvents
 	char *ip;
 	int port;
 	char *pwd;
+	char *usocket;
 	int db;
 };
 
@@ -223,12 +224,13 @@ void send_message_to_redis(redis_context_handle rch, c
 
 ///////////////////////// Attach /////////////////////////////////
 
-redis_context_handle redisLibeventAttach(struct event_base *base, char *ip0, int port0, char *pwd, int db)
+redis_context_handle redisLibeventAttach(struct event_base *base, char *ip0, int port0, char *pwd, char *usocket, int db)
 {
 
   struct redisLibeventEvents *e = NULL;
   redisAsyncContext *ac = NULL;
 
+  char sockpath[256] = "\0";
   char ip[256];
   if(ip0 && ip0[0])
 	  STRCPY(ip,ip0);
@@ -239,7 +241,14 @@ redis_context_handle redisLibeventAttach(struct event_
   if(port0>0)
 	  port=port0;
 
-  ac = redisAsyncConnect(ip, port);
+  if(usocket)
+	  STRCPY(sockpath, usocket);
+
+  if(usocket) {
+	ac = redisAsyncConnectUnix(sockpath);
+  } else {
+	ac = redisAsyncConnect(ip, port);
+  }
   if (!ac) {
   	fprintf(stderr,"Error: %s:%s\n", ac->errstr, ac->c.errstr);
   	return NULL;
@@ -256,6 +265,11 @@ redis_context_handle redisLibeventAttach(struct event_
   e->port = port;
   if(pwd)
 	  e->pwd = strdup(pwd);
+  if(usocket) {
+	  e->usocket = strdup(usocket);
+  } else {
+	  e->usocket = NULL;
+  }  
   e->db = db;
 
   /* Register functions to start/stop listening for events */
@@ -277,6 +291,12 @@ redis_context_handle redisLibeventAttach(struct event_
   		     e);
 
   if (e->rev == NULL || e->wev == NULL) {
+          if(e->rev)
+          	    event_free(e->rev);
+          if(e->wev)
+          	    event_free(e->wev);
+          free(e->ip);
+          free(e->pwd);
 	  free(e);
 	  return NULL;
   }
@@ -327,7 +347,11 @@ static void redis_reconnect(struct redisLibeventEvents
 	  e->context = NULL;
   }
 
-  ac = redisAsyncConnect(e->ip, e->port);
+  if(e->usocket) {
+	ac = redisAsyncConnectUnix(e->usocket);
+  } else {
+	ac = redisAsyncConnect(e->ip, e->port);
+  }
   if(!ac) {
 	  return;
   }
