--- src/apps/relay/dbdrivers/dbd_redis.c.orig	2024-12-11 18:13:38 UTC
+++ src/apps/relay/dbdrivers/dbd_redis.c
@@ -49,6 +49,7 @@ struct _Ryconninfo {
 struct _Ryconninfo {
   char *host;
   char *dbname;
+  char *usocket;
   char *user;
   char *password;
   unsigned int connect_timeout;
@@ -65,6 +66,9 @@ static void RyconninfoFree(Ryconninfo *co) {
     if (co->dbname) {
       free(co->dbname);
     }
+    if (co->usocket) {
+      free(co->usocket);
+    }
     if (co->user) {
       free(co->user);
     }
@@ -114,6 +118,10 @@ static Ryconninfo *RyconninfoParse(const char *userdb,
         co->host = strdup(seq + 1);
       } else if (!strcmp(s, "hostaddr")) {
         co->host = strdup(seq + 1);
+      } else if (!strcmp(s, "socket")) {
+        co->usocket = strdup(seq + 1);
+      } else if (!strcmp(s, "unix")) {
+        co->usocket = strdup(seq + 1);
       } else if (!strcmp(s, "dbname")) {
         co->dbname = strdup(seq + 1);
       } else if (!strcmp(s, "db")) {
@@ -201,6 +209,7 @@ redis_context_handle get_redis_async_connection(struct
         redisContext *rc = NULL;
 
         char ip[256] = "\0";
+        char sockpath[256] = "\0";
         int port = DEFAULT_REDIS_PORT;
         if (co->host) {
           STRCPY(ip, co->host);
@@ -213,13 +222,25 @@ redis_context_handle get_redis_async_connection(struct
           port = (int)(co->port);
         }
 
+        if (co->usocket) {
+          STRCPY(sockpath, co->usocket);
+        }
+
         if (co->connect_timeout) {
           struct timeval tv;
           tv.tv_usec = 0;
           tv.tv_sec = (time_t)(co->connect_timeout);
-          rc = redisConnectWithTimeout(ip, port, tv);
+          if (co->usocket) {
+            rc = redisConnectUnixWithTimeout(sockpath, tv);
+          } else {
+            rc = redisConnectWithTimeout(ip, port, tv);
+          }
         } else {
-          rc = redisConnect(ip, port);
+          if (co->usocket) {
+            rc = redisConnectUnix(sockpath);
+          } else {
+            rc = redisConnect(ip, port);
+          }
         }
 
         if (!rc) {
@@ -272,7 +293,7 @@ redis_context_handle get_redis_async_connection(struct
         }
       }
 
-      ret = redisLibeventAttach(base, co->host, co->port, co->user, co->password, atoi(co->dbname));
+      ret = redisLibeventAttach(base, co->host, co->port, co->usocket, co->user, co->password, atoi(co->dbname));
 
       if (!ret) {
         TURN_LOG_FUNC(TURN_LOG_LEVEL_ERROR, "Cannot initialize Redis DB connection\n");
@@ -324,6 +345,7 @@ static redisContext *get_redis_connection(void) {
       RyconninfoFree(co);
     } else {
       char ip[256] = "\0";
+      char sockpath[256] = "\0";
       int port = DEFAULT_REDIS_PORT;
       if (co->host) {
         STRCPY(ip, co->host);
@@ -336,13 +358,25 @@ static redisContext *get_redis_connection(void) {
         port = (int)(co->port);
       }
 
+      if (co->usocket) {
+        STRCPY(sockpath, co->usocket);
+      }
+
       if (co->connect_timeout) {
         struct timeval tv;
         tv.tv_usec = 0;
         tv.tv_sec = (time_t)(co->connect_timeout);
-        redisconnection = redisConnectWithTimeout(ip, port, tv);
+        if (co->usocket) {
+          redisconnection = redisConnectUnixWithTimeout(sockpath, tv);
+        } else {
+          redisconnection = redisConnectWithTimeout(ip, port, tv);
+        }
       } else {
-        redisconnection = redisConnect(ip, port);
+        if (co->usocket) {
+          redisconnection = redisConnectUnix(sockpath);
+        } else {
+          redisconnection = redisConnect(ip, port);
+        }
       }
 
       if (redisconnection) {
