--- src/apps/relay/dbdrivers/dbd_redis.c.orig	2019-03-02 21:06:19 UTC
+++ src/apps/relay/dbdrivers/dbd_redis.c
@@ -50,6 +50,7 @@ struct _Ryconninfo {
 	char *host;
 	char *dbname;
 	char *password;
+	char *usocket;
 	unsigned int connect_timeout;
 	unsigned int port;
 };
@@ -61,6 +62,7 @@ static void RyconninfoFree(Ryconninfo *co) {
 		if(co->host) turn_free(co->host, strlen(co->host)+1);
 		if(co->dbname) turn_free(co->dbname, strlen(co->dbname)+1);
 		if(co->password) turn_free(co->password, strlen(co->password)+1);
+		if(co->usocket) turn_free(co->usocket, strlen(co->usocket)+1);
 		ns_bzero(co,sizeof(Ryconninfo));
 	}
 }
@@ -103,6 +105,8 @@ static Ryconninfo *RyconninfoParse(const char *userdb,
 				co->host = turn_strdup(seq + 1);
 			else if (!strcmp(s, "hostaddr"))
 				co->host = turn_strdup(seq + 1);
+			else if (!strcmp(s, "socket"))
+				co->usocket = turn_strdup(seq + 1);
 			else if (!strcmp(s, "dbname"))
 				co->dbname = turn_strdup(seq + 1);
 			else if (!strcmp(s, "db"))
@@ -185,6 +189,7 @@ redis_context_handle get_redis_async_connection(struct
 				redisContext *rc = NULL;
 
 				char ip[256] = "\0";
+				char sockpath[256] = "\0";
 				int port = DEFAULT_REDIS_PORT;
 				if (co->host)
 					STRCPY(ip,co->host);
@@ -194,13 +199,24 @@ redis_context_handle get_redis_async_connection(struct
 				if (co->port)
 					port = (int) (co->port);
 
+				if (co->usocket)
+					STRCPY(sockpath,co->usocket);
+
 				if (co->connect_timeout) {
 					struct timeval tv;
 					tv.tv_usec = 0;
 					tv.tv_sec = (time_t) (co->connect_timeout);
-					rc = redisConnectWithTimeout(ip, port, tv);
+					if (co->usocket) {
+						rc = redisConnectUnixWithTimeout(sockpath, tv);
+					} else {
+						rc = redisConnectWithTimeout(ip, port, tv);
+					}
 				} else {
-					rc = redisConnect(ip, port);
+					if (co->usocket) {
+						rc = redisConnectUnix(sockpath);
+					} else {
+						rc = redisConnect(ip, port);
+					}
 				}
 
 				if (!rc) {
@@ -248,7 +264,7 @@ redis_context_handle get_redis_async_connection(struct
 				}
 			}
 
-			ret = redisLibeventAttach(base, co->host, co->port, co->password, atoi(co->dbname));
+			ret = redisLibeventAttach(base, co->host, co->port, co->password, co->usocket, atoi(co->dbname));
 
 			if (!ret) {
 				TURN_LOG_FUNC(TURN_LOG_LEVEL_ERROR, "Cannot initialize Redis DB connection\n");
@@ -294,12 +310,16 @@ static redisContext *get_redis_connection(void) {
 			RyconninfoFree(co);
 		} else {
 			char ip[256] = "\0";
+			char sockpath[256] = "\0";
 			int port = DEFAULT_REDIS_PORT;
 			if (co->host)
 				STRCPY(ip,co->host);
 			if (!ip[0])
 				STRCPY(ip,"127.0.0.1");
 
+			if (co->usocket)
+				STRCPY(sockpath,co->usocket);
+
 			if (co->port)
 				port = (int) (co->port);
 
@@ -307,9 +327,17 @@ static redisContext *get_redis_connection(void) {
 				struct timeval tv;
 				tv.tv_usec = 0;
 				tv.tv_sec = (time_t) (co->connect_timeout);
-				redisconnection = redisConnectWithTimeout(ip, port, tv);
+				if (co->usocket) {
+					redisconnection = redisConnectUnixWithTimeout(sockpath, tv);
+				} else {
+					redisconnection = redisConnectWithTimeout(ip, port, tv);
+				}
 			} else {
-				redisconnection = redisConnect(ip, port);
+				if (co->usocket) {
+					redisconnection = redisConnectUnix(sockpath);
+				} else {
+					redisconnection = redisConnect(ip, port);
+				}
 			}
 
 			if (redisconnection) {
