--- promhttp/src/promhttp.c.orig	2020-12-08 07:38:13 UTC
+++ promhttp/src/promhttp.c
@@ -29,32 +29,32 @@ void promhttp_set_active_collector_registry(prom_colle
   }
 }
 
-int promhttp_handler(void *cls, struct MHD_Connection *connection, const char *url, const char *method,
+enum MHD_Result promhttp_handler(void *cls, struct MHD_Connection *connection, const char *url, const char *method,
                      const char *version, const char *upload_data, size_t *upload_data_size, void **con_cls) {
   if (strcmp(method, "GET") != 0) {
     char *buf = "Invalid HTTP Method\n";
     struct MHD_Response *response = MHD_create_response_from_buffer(strlen(buf), (void *)buf, MHD_RESPMEM_PERSISTENT);
-    int ret = MHD_queue_response(connection, MHD_HTTP_BAD_REQUEST, response);
+    enum MHD_Result ret = MHD_queue_response(connection, MHD_HTTP_BAD_REQUEST, response);
     MHD_destroy_response(response);
     return ret;
   }
   if (strcmp(url, "/") == 0) {
     char *buf = "OK\n";
     struct MHD_Response *response = MHD_create_response_from_buffer(strlen(buf), (void *)buf, MHD_RESPMEM_PERSISTENT);
-    int ret = MHD_queue_response(connection, MHD_HTTP_OK, response);
+    enum MHD_Result ret = MHD_queue_response(connection, MHD_HTTP_OK, response);
     MHD_destroy_response(response);
     return ret;
   }
   if (strcmp(url, "/metrics") == 0) {
     const char *buf = prom_collector_registry_bridge(PROM_ACTIVE_REGISTRY);
     struct MHD_Response *response = MHD_create_response_from_buffer(strlen(buf), (void *)buf, MHD_RESPMEM_MUST_FREE);
-    int ret = MHD_queue_response(connection, MHD_HTTP_OK, response);
+    enum MHD_Result ret = MHD_queue_response(connection, MHD_HTTP_OK, response);
     MHD_destroy_response(response);
     return ret;
   }
   char *buf = "Bad Request\n";
   struct MHD_Response *response = MHD_create_response_from_buffer(strlen(buf), (void *)buf, MHD_RESPMEM_PERSISTENT);
-  int ret = MHD_queue_response(connection, MHD_HTTP_BAD_REQUEST, response);
+  enum MHD_Result ret = MHD_queue_response(connection, MHD_HTTP_BAD_REQUEST, response);
   MHD_destroy_response(response);
   return ret;
 }
